/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.jasper.jspc.CompileJSPTask;
import com.liferay.gradle.plugins.jasper.jspc.JspCPlugin;
import com.liferay.gradle.plugins.util.FileUtil;
import com.liferay.gradle.plugins.util.GradleUtil;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;

public class JspCDefaultsPlugin
extends BasePortalToolDefaultsPlugin<JspCPlugin> {
    public static final String JSP_PRECOMPILE_ENABLED_PROPERTY_NAME = "jsp.precompile.enabled";
    public static final String UNZIP_JAR_TASK_NAME = "unzipJar";
    private static final String _PORTAL_TOOL_NAME = "com.liferay.jasper.jspc";
    private static final OsgiHelper _osgiHelper = new OsgiHelper();

    protected void addDependenciesJspC(Project project) {
        ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{this.getUnzippedJarDir(project)});
        configurableFileCollection.builtBy(new Object[]{UNZIP_JAR_TASK_NAME});
        GradleUtil.addDependency((Project)project, (String)"jspC", (FileCollection)configurableFileCollection);
    }

    @Override
    protected void addPortalToolDependencies(Project project) {
        super.addPortalToolDependencies(project);
        GradleUtil.addDependency((Project)project, (String)this.getPortalToolConfigurationName(), (String)"org.apache.ant", (String)"ant", (String)"1.9.4");
    }

    protected Task addTaskUnzipJar(Project project) {
        Task task = project.task(UNZIP_JAR_TASK_NAME);
        final Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        task.dependsOn(new Object[]{jar});
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                FileUtil.unzip(project, jar.getArchivePath(), JspCDefaultsPlugin.this.getUnzippedJarDir(project));
            }
        });
        return task;
    }

    @Override
    protected void configureDefaults(Project project, JspCPlugin jspCPlugin) {
        super.configureDefaults(project, jspCPlugin);
        this.addTaskUnzipJar(project);
        this.configureTaskGenerateJSPJava(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                JspCDefaultsPlugin.this.addDependenciesJspC(project);
                JspCDefaultsPlugin.this.configureTaskCompileJSP(project);
            }
        });
    }

    protected void configureTaskCompileJSP(Project project) {
        boolean jspPrecompileEnabled = GradleUtil.getProperty((ExtensionAware)project, (String)JSP_PRECOMPILE_ENABLED_PROPERTY_NAME, (boolean)false);
        if (!jspPrecompileEnabled) {
            return;
        }
        JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)project, (String)"compileJSP");
        String dirName = _osgiHelper.getBundleSymbolicName(project) + "-" + project.getVersion();
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        File dir = new File(liferayExtension.getLiferayHome(), "work/" + dirName);
        javaCompile.setDestinationDir(dir);
    }

    protected void configureTaskGenerateJSPJava(final Project project) {
        CompileJSPTask compileJSPTask = (CompileJSPTask)GradleUtil.getTask((Project)project, (String)"generateJSPJava");
        compileJSPTask.setWebAppDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File unzippedJarDir = JspCDefaultsPlugin.this.getUnzippedJarDir(project);
                File resourcesDir = new File(unzippedJarDir, "META-INF/resources");
                if (resourcesDir.exists()) {
                    return resourcesDir;
                }
                return unzippedJarDir;
            }
        });
    }

    @Override
    protected Class<JspCPlugin> getPluginClass() {
        return JspCPlugin.class;
    }

    @Override
    protected String getPortalToolConfigurationName() {
        return "jspCTool";
    }

    @Override
    protected String getPortalToolName() {
        return _PORTAL_TOOL_NAME;
    }

    protected File getUnzippedJarDir(Project project) {
        return new File(project.getBuildDir(), "unzipped-jar");
    }
}

