/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.wsdl.builder;

import com.liferay.gradle.plugins.wsdl.builder.BuildWSDLTask;
import com.liferay.gradle.plugins.wsdl.builder.GenerateOptions;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;

public class WSDLBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_WSDL_TASK_NAME = "buildWSDL";
    public static final String CONFIGURATION_NAME = "wsdlBuilder";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        final Configuration wsdlBuilderConfiguration = this._addConfigurationWSDLBuilder(project);
        this._addTaskBuildWSDL(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                WSDLBuilderPlugin.this._configureTasksBuildWSDL(project, wsdlBuilderConfiguration);
            }
        });
    }

    private Configuration _addConfigurationWSDLBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                WSDLBuilderPlugin.this._addDependenciesWSDLBuilder(project);
            }
        });
        configuration.setDescription("Configures Apache Axis for generating WSDL client stubs.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesWSDLBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"axis", (String)"axis-wsdl4j", (String)"1.5.1");
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"org.apache.axis", (String)"1.4.LIFERAY-PATCHED-1");
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"commons-discovery", (String)"commons-discovery", (String)"0.2");
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"commons-logging", (String)"commons-logging", (String)"1.0.4");
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"javax.activation", (String)"activation", (String)"1.1");
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"javax.mail", (String)"mail", (String)"1.4");
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"org.apache.axis", (String)"axis-jaxrpc", (String)"1.4");
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"org.apache.axis", (String)"axis-saaj", (String)"1.4");
    }

    private BuildWSDLTask _addTaskBuildWSDL(Project project) {
        final BuildWSDLTask buildWSDLTask = (BuildWSDLTask)GradleUtil.addTask((Project)project, (String)BUILD_WSDL_TASK_NAME, BuildWSDLTask.class);
        buildWSDLTask.setDescription("Generates WSDL client stubs.");
        buildWSDLTask.setDestinationDir(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (buildWSDLTask.isBuildLibs()) {
                    return "lib";
                }
                return WSDLBuilderPlugin.this._getJavaDir(buildWSDLTask.getProject());
            }
        });
        buildWSDLTask.setGroup("build");
        buildWSDLTask.setIncludes(Collections.singleton("**/*.wsdl"));
        buildWSDLTask.setSource("wsdl");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                WSDLBuilderPlugin.this._configureTaskBuildWSDLForWarPlugin(buildWSDLTask);
            }
        });
        return buildWSDLTask;
    }

    private Task _addTaskBuildWSDLCompile(BuildWSDLTask buildWSDLTask, FileCollection classpath, File inputFile, File tmpDir, Task generateTask) {
        Project project = buildWSDLTask.getProject();
        String taskName = GradleUtil.getTaskName((String)(buildWSDLTask.getName() + "Compile"), (File)inputFile);
        JavaCompile javaCompile = (JavaCompile)GradleUtil.addTask((Project)project, (String)taskName, JavaCompile.class);
        javaCompile.setClasspath(classpath);
        File tmpBinDir = new File(tmpDir, "bin");
        javaCompile.setDestinationDir(tmpBinDir);
        javaCompile.setSource((Object)generateTask.getOutputs());
        return javaCompile;
    }

    private Task _addTaskBuildWSDLGenerate(BuildWSDLTask buildWSDLTask, FileCollection classpath, File inputFile, final File destinationDir) {
        Project project = buildWSDLTask.getProject();
        String taskName = GradleUtil.getTaskName((String)(buildWSDLTask.getName() + "Generate"), (File)inputFile);
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)project, (String)taskName, JavaExec.class);
        GenerateOptions generateOptions = buildWSDLTask.getGenerateOptions();
        javaExec.args(generateOptions.getArgs());
        javaExec.args(new Object[]{"--output=" + FileUtil.getAbsolutePath((File)destinationDir)});
        javaExec.args(new Object[]{FileUtil.getAbsolutePath((File)inputFile)});
        javaExec.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                project.delete(new Object[]{destinationDir});
            }
        });
        javaExec.setClasspath(classpath);
        javaExec.setMain("org.apache.axis.wsdl.WSDL2Java");
        TaskInputs taskInputs = javaExec.getInputs();
        taskInputs.file((Object)inputFile);
        TaskOutputsInternal taskOutputs = javaExec.getOutputs();
        taskOutputs.dir((Object)destinationDir);
        return javaExec;
    }

    private Jar _addTaskBuildWSDLJar(BuildWSDLTask buildWSDLTask, File inputFile, Task compileTask, final Task generateTask) {
        Project project = buildWSDLTask.getProject();
        String taskName = GradleUtil.getTaskName((String)buildWSDLTask.getName(), (File)inputFile);
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)taskName, Jar.class);
        jar.from(new Object[]{compileTask.getOutputs()});
        if (buildWSDLTask.isIncludeSource()) {
            jar.into((Object)"OSGI-OPT/src", (Closure)new Closure<Void>((Object)project){

                public void doCall(CopySpec copySpec) {
                    copySpec.from(new Object[]{generateTask.getOutputs()});
                }
            });
        }
        jar.setDestinationDir(buildWSDLTask.getDestinationDir());
        String wsdlName = FileUtil.stripExtension((String)inputFile.getName());
        jar.setArchiveName(wsdlName + "-ws.jar");
        return jar;
    }

    private void _addTaskBuildWSDLTasks(BuildWSDLTask buildWSDLTask, File inputFile, Configuration wsdlBuilderConfiguration) {
        Project project = buildWSDLTask.getProject();
        if (buildWSDLTask.isBuildLibs()) {
            String tmpDirName = "build-wsdl/" + FileUtil.stripExtension((String)inputFile.getName());
            File tmpDir = new File(project.getBuildDir(), tmpDirName);
            File tmpSrcDir = new File(tmpDir, "src");
            Task generateTask = this._addTaskBuildWSDLGenerate(buildWSDLTask, (FileCollection)wsdlBuilderConfiguration, inputFile, tmpSrcDir);
            Task compileTask = this._addTaskBuildWSDLCompile(buildWSDLTask, (FileCollection)wsdlBuilderConfiguration, inputFile, tmpDir, generateTask);
            Jar jar = this._addTaskBuildWSDLJar(buildWSDLTask, inputFile, compileTask, generateTask);
            buildWSDLTask.dependsOn(new Object[]{jar});
            TaskOutputsInternal taskOutputs = buildWSDLTask.getOutputs();
            taskOutputs.file((Object)jar.getArchivePath());
        } else {
            Task generateTask = this._addTaskBuildWSDLGenerate(buildWSDLTask, (FileCollection)wsdlBuilderConfiguration, inputFile, buildWSDLTask.getDestinationDir());
            buildWSDLTask.dependsOn(new Object[]{generateTask});
        }
    }

    private void _configureTaskBuildWSDL(final BuildWSDLTask buildWSDLTask, Copy processResourcesTask, Configuration wsdlBuilderConfiguration) {
        FileTree fileCollection = buildWSDLTask.getSource();
        if (fileCollection.isEmpty()) {
            return;
        }
        Project project = buildWSDLTask.getProject();
        for (File inputFile : fileCollection) {
            this._addTaskBuildWSDLTasks(buildWSDLTask, inputFile, wsdlBuilderConfiguration);
        }
        if (buildWSDLTask.isBuildLibs()) {
            TaskOutputsInternal taskOutputs = buildWSDLTask.getOutputs();
            GradleUtil.addDependency((Project)project, (String)"compile", (FileCollection)taskOutputs.getFiles());
        }
        if (buildWSDLTask.isIncludeWSDLs() && processResourcesTask != null) {
            processResourcesTask.into((Object)"wsdl", (Closure)new Closure<Void>((Object)project){

                public void doCall(CopySpec copySpec) {
                    copySpec.from(new Object[]{buildWSDLTask.getSource()});
                }
            });
        }
    }

    private void _configureTaskBuildWSDLForWarPlugin(final BuildWSDLTask buildWSDLTask) {
        buildWSDLTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (buildWSDLTask.isBuildLibs()) {
                    return new File(WSDLBuilderPlugin.this._getWebAppDir(buildWSDLTask.getProject()), "WEB-INF/lib");
                }
                return WSDLBuilderPlugin.this._getJavaDir(buildWSDLTask.getProject());
            }
        });
        buildWSDLTask.setSource(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(WSDLBuilderPlugin.this._getWebAppDir(buildWSDLTask.getProject()), "WEB-INF/wsdl");
            }
        });
    }

    private void _configureTasksBuildWSDL(Project project, final Configuration wsdlBuilderConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        final Copy processResourcesTask = (Copy)taskContainer.findByName("processResources");
        taskContainer.withType(BuildWSDLTask.class, (Action)new Action<BuildWSDLTask>(){

            public void execute(BuildWSDLTask buildWSDLTask) {
                WSDLBuilderPlugin.this._configureTaskBuildWSDL(buildWSDLTask, processResourcesTask, wsdlBuilderConfiguration);
            }
        });
    }

    private File _getJavaDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this._getSrcDir(sourceSet.getJava());
    }

    private File _getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    private File _getWebAppDir(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        return warPluginConvention.getWebAppDir();
    }
}

