/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.wsdd.builder;

import com.liferay.gradle.plugins.wsdd.builder.WSDDBuilderTask;
import com.liferay.gradle.plugins.wsdd.builder.util.Validator;
import com.liferay.portal.tools.wsdd.builder.WSDDBuilderArgs;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;

public class WSDDBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_WSDD_TASK_NAME = "buildWSDD";
    public static final String CONFIGURATION_NAME = "wsddBuilder";

    public void apply(Project project) {
        this.addWSDDBuilderConfiguration(project);
        final WSDDBuilderArgs wsddBuilderArgs = this.addWSDDBuilderExtension(project);
        this.addBuildWSDDTask(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                WSDDBuilderPlugin.this.configureWSDDBuilderExtension(project, wsddBuilderArgs);
            }
        });
    }

    protected Task addBuildWSDDTask(Project project) {
        TaskContainer taskContainer = project.getTasks();
        Task task = taskContainer.create(BUILD_WSDD_TASK_NAME, WSDDBuilderTask.class);
        task.setDescription("Runs Liferay WSDD Builder.");
        task.setGroup("build");
        return task;
    }

    protected Configuration addWSDDBuilderConfiguration(final Project project) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        final Configuration configuration = (Configuration)configurationContainer.create(CONFIGURATION_NAME);
        configuration.setDescription("Configures Liferay WSDD Builder for this project.");
        configuration.setVisible(false);
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        resolvableDependencies.beforeResolve((Action)new Action<ResolvableDependencies>(){

            public void execute(ResolvableDependencies resolvableDependencies) {
                DependencySet dependencies = configuration.getDependencies();
                if (dependencies.isEmpty()) {
                    WSDDBuilderPlugin.this.addWSDDBuilderDependencies(project);
                }
            }
        });
        return configuration;
    }

    protected void addWSDDBuilderDependencies(Project project) {
        DependencyHandler dependencyHandler = project.getDependencies();
        dependencyHandler.add(CONFIGURATION_NAME, (Object)"com.liferay:com.liferay.portal.tools.wsdd.builder:latest.release");
    }

    protected WSDDBuilderArgs addWSDDBuilderExtension(Project project) {
        ExtensionContainer extensionContainer = project.getExtensions();
        return (WSDDBuilderArgs)extensionContainer.create(CONFIGURATION_NAME, WSDDBuilderArgs.class, new Object[0]);
    }

    protected void configureWSDDBuilderExtension(Project project, WSDDBuilderArgs wsddBuilderArgs) {
        if (Validator.isNotNull(wsddBuilderArgs.getClassPath())) {
            return;
        }
        TaskContainer taskContainer = project.getTasks();
        Task compileJavaTask = (Task)taskContainer.findByName("compileJava");
        if (compileJavaTask == null) {
            return;
        }
        Task buildWSDDTask = taskContainer.getByName(BUILD_WSDD_TASK_NAME);
        buildWSDDTask.dependsOn(new Object[]{compileJavaTask});
        TaskOutputs taskOutputs = compileJavaTask.getOutputs();
        FileCollection fileCollection = taskOutputs.getFiles();
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration configuration = (Configuration)configurationContainer.findByName("runtime");
        if (configuration != null) {
            fileCollection = fileCollection.plus((FileCollection)configuration);
        }
        wsddBuilderArgs.setClassPath(fileCollection.getAsPath());
    }
}

