/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.tasks;

import com.liferay.gradle.plugins.workspace.configurators.RootProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.tasks.TaskAction;

public class CreateClientExtensionConfigTask
extends DefaultTask {
    private static final String _CLIENT_EXTENSION_CONFIG_FILE_NAME = ".client-extension-config.json";
    private static final String _CLIENT_EXTENSION_DOCKERFILE = "client_extension_Dockerfile";
    private static final String _CLIENT_EXTENSION_LCP_JSON = "client_extension_LCP.json";
    private final Set<ClientExtension> _clientExtensions = new LinkedHashSet<ClientExtension>();
    private Object _dockerFile;
    private Object _lcpJsonFile;

    public CreateClientExtensionConfigTask() {
        Project project = this.getProject();
        ProjectLayout projectLayout = project.getLayout();
        DirectoryProperty buildDirectoryProperty = projectLayout.getBuildDirectory();
        this._dockerFile = buildDirectoryProperty.file("Dockerfile");
        this._lcpJsonFile = buildDirectoryProperty.file("LCP.json");
        TaskOutputsInternal taskOutputs = this.getOutputs();
        taskOutputs.files(new Object[]{this._dockerFile, this._lcpJsonFile});
    }

    public void addClientExtension(ClientExtension clientExtension) {
        this._clientExtensions.add(clientExtension);
        Project project = this.getProject();
        File clientExtensionConfigFile = new File(project.getBuildDir(), clientExtension.id + _CLIENT_EXTENSION_CONFIG_FILE_NAME);
        TaskOutputsInternal taskOutputs = this.getOutputs();
        taskOutputs.file((Object)clientExtensionConfigFile);
    }

    @TaskAction
    public void createClientExtensionConfig() {
        Project project = this.getProject();
        File outputDockerFile = this.getDockerFile();
        try {
            String dockerFileContent = this._loadTemplate("client_extension_Dockerfile.tpl", Collections.emptyMap());
            File inputDockerFile = project.file((Object)"Dockerfile");
            if (inputDockerFile.exists()) {
                dockerFileContent = new String(Files.readAllBytes(inputDockerFile.toPath()));
            }
            Files.write(outputDockerFile.toPath(), dockerFileContent.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
        File outputLcpJsonFile = this.getLcpJsonFile();
        try {
            String projectName = project.getName();
            String lcpJsonContent = this._loadTemplate("client_extension_LCP.json.tpl", Collections.singletonMap("__CLIENT_EXTENSION_ID__", projectName.toLowerCase()));
            File inputLcpJsonFile = project.file((Object)"LCP.json");
            if (inputLcpJsonFile.exists()) {
                lcpJsonContent = new String(Files.readAllBytes(inputLcpJsonFile.toPath()));
            }
            Files.write(outputLcpJsonFile.toPath(), lcpJsonContent.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
        this._clientExtensions.forEach(clientExtension -> {
            File clientExtensionConfigFile = new File(project.getBuildDir(), clientExtension.id + _CLIENT_EXTENSION_CONFIG_FILE_NAME);
            File parentFile = clientExtensionConfigFile.getParentFile();
            parentFile.mkdirs();
            try {
                String json = clientExtension.toJSON();
                Files.write(clientExtensionConfigFile.toPath(), json.getBytes(), new OpenOption[0]);
            }
            catch (Exception exception) {
                throw new GradleException(exception.getMessage(), (Throwable)exception);
            }
        });
    }

    public Set<ClientExtension> getClientExtensions() {
        return this._clientExtensions;
    }

    public File getDockerFile() {
        return GradleUtil.toFile(this.getProject(), this._dockerFile);
    }

    public File getLcpJsonFile() {
        return GradleUtil.toFile(this.getProject(), this._lcpJsonFile);
    }

    public void setDockerFile(Object dockerFile) {
        this._dockerFile = dockerFile;
    }

    public void setLcpJsonFile(Object lcpJsonFile) {
        this._lcpJsonFile = lcpJsonFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _loadTemplate(String name, Map<String, String> substitutionMap) {
        try (InputStream inputStream = RootProjectConfigurator.class.getResourceAsStream("dependencies/" + name);){
            Set<Map.Entry<String, String>> entrySet = substitutionMap.entrySet();
            Stream substitutions = entrySet.stream();
            String string = (String)substitutions.map(entry -> s -> s.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue())).reduce(Function::andThen).orElse(Function.identity()).apply(StringUtil.read(inputStream));
            return string;
        }
        catch (Exception exception) {
            throw new GradleException("Unable to read template " + name, (Throwable)exception);
        }
    }
}

