/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.tasks;

import com.liferay.gradle.plugins.workspace.internal.util.FileUtil;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.portal.tools.bundle.support.commands.CreateTokenCommand;
import com.liferay.portal.tools.bundle.support.constants.BundleSupportConstants;
import groovy.lang.Closure;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import org.gradle.api.AntBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class CreateTokenTask
extends DefaultTask {
    private Object _emailAddress;
    private Object _force;
    private Object _password;
    private Object _passwordFile;
    private Object _tokenFile = BundleSupportConstants.DEFAULT_TOKEN_FILE;
    private Object _tokenUrl = "https://web.liferay.com/token-auth-portlet/api/secure/jsonws/tokenauthentry/add-token-auth-entry";

    public CreateTokenTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                CreateTokenTask createTokenTask = (CreateTokenTask)task;
                File tokenFile = createTokenTask.getTokenFile();
                return createTokenTask.isForce() || !tokenFile.exists();
            }
        });
    }

    @TaskAction
    public void createToken() throws Exception {
        this._setCredentials();
        CreateTokenCommand createTokenCommand = new CreateTokenCommand();
        createTokenCommand.setEmailAddress(this.getEmailAddress());
        createTokenCommand.setForce(this.isForce());
        createTokenCommand.setPassword(this.getPassword());
        createTokenCommand.setTokenFile(this.getTokenFile());
        createTokenCommand.setTokenUrl(this.getTokenUrl());
        createTokenCommand.execute();
    }

    @Input
    @Optional
    public String getEmailAddress() {
        return GradleUtil.toString((Object)this._emailAddress);
    }

    @Input
    @Optional
    public String getPassword() {
        return GradleUtil.toString((Object)this._password);
    }

    @InputFile
    @Optional
    public File getPasswordFile() {
        return GradleUtil.toFile(this.getProject(), this._passwordFile);
    }

    @Input
    public File getTokenFile() {
        return GradleUtil.toFile(this.getProject(), this._tokenFile);
    }

    @Input
    public URL getTokenUrl() {
        return GradleUtil.toURL(this._tokenUrl);
    }

    public boolean isForce() {
        return GradleUtil.toBoolean(this._force);
    }

    public void setEmailAddress(Object emailAddress) {
        this._emailAddress = emailAddress;
    }

    public void setForce(Object force) {
        this._force = force;
    }

    public void setPassword(Object password) {
        this._password = password;
    }

    @Input
    public void setPasswordFile(Object passwordFile) {
        this._passwordFile = passwordFile;
    }

    @Input
    public void setTokenFile(Object tokenFile) {
        this._tokenFile = tokenFile;
    }

    public void setURL(Object tokenUrl) {
        this._tokenUrl = tokenUrl;
    }

    private String _readInput(final AntBuilder antBuilder, String message, String propertySuffix, final boolean secure) {
        String propertyName = this.getName() + "." + propertySuffix;
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("addproperty", propertyName);
        args.put("message", message);
        Closure<Void> closure = new Closure<Void>((Object)antBuilder){

            public void doCall() {
                if (secure) {
                    antBuilder.invokeMethod("handler", Collections.singletonMap("type", "secure"));
                }
            }
        };
        antBuilder.invokeMethod("input", (Object)new Object[]{args, closure});
        return (String)antBuilder.getProperty(propertyName);
    }

    private void _setCredentials() {
        String emailAddress = this.getEmailAddress();
        String password = this.getPassword();
        File passwordFile = this.getPasswordFile();
        if (Validator.isNotNull((String)emailAddress) && (Validator.isNotNull((String)password) || passwordFile != null)) {
            return;
        }
        Project project = this.getProject();
        AntBuilder antBuilder = project.createAntBuilder();
        while (Validator.isNull((String)emailAddress)) {
            emailAddress = this._readInput(antBuilder, "Email Address:", "email.address", false);
        }
        this.setEmailAddress(emailAddress);
        if (passwordFile != null) {
            password = FileUtil.read(passwordFile);
        } else {
            while (Validator.isNull((String)password)) {
                password = this._readInput(antBuilder, "Password:", "password", true);
            }
        }
        this.setPassword(password);
    }
}

