/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.gradle.api.UncheckedIOException;

public class FileUtil
extends com.liferay.gradle.util.FileUtil {
    public static void moveTree(File sourceRootDir, File destinationRootDir) {
        try {
            FileUtil._moveTree(sourceRootDir.toPath(), destinationRootDir.toPath());
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    private static void _moveTree(final Path sourceRootDirPath, final Path destinationRootDirPath) throws IOException {
        Files.walkFileTree(sourceRootDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioe) throws IOException {
                Files.delete(dirPath);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                Path relativePath = sourceRootDirPath.relativize(dirPath);
                Path destinationDirPath = destinationRootDirPath.resolve(relativePath);
                Files.createDirectories(destinationDirPath, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

