/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.testray;

import com.liferay.gradle.plugins.testray.TestrayExtension;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.JavaExec;
import org.gradle.util.GUtil;

public class TestrayPlugin
implements Plugin<Project> {
    public static final String IMPORT_TESTRAY_RESULTS_TASK_NAME = "importTestrayResults";
    public static final String TESTRAY_CONFIGURATION_NAME = "testray";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        final TestrayExtension testrayExtension = (TestrayExtension)GradleUtil.addExtension((ExtensionAware)project, (String)TESTRAY_CONFIGURATION_NAME, TestrayExtension.class);
        this._addConfigurationTestray(project, testrayExtension);
        final JavaExec importTestrayResultsTask = this._addTaskImportTestrayResults(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                TestrayPlugin.this._configureTaskImportTestrayResults(importTestrayResultsTask, testrayExtension);
            }
        });
    }

    private Configuration _addConfigurationTestray(final Project project, final TestrayExtension testrayExtension) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)TESTRAY_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                TestrayPlugin.this._addDependenciesTestray(project, testrayExtension);
            }
        });
        configuration.setDescription("Configures Testray for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesTestray(Project project, TestrayExtension testrayExtension) {
        GradleUtil.addDependency((Project)project, (String)TESTRAY_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.jenkins.results.parser", (String)testrayExtension.getJenkinsResultsParserVersion());
    }

    private JavaExec _addTaskImportTestrayResults(Project project) {
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)project, (String)IMPORT_TESTRAY_RESULTS_TASK_NAME, JavaExec.class);
        javaExec.setClasspath(this._getTestrayClasspath(project));
        javaExec.setDescription("Import Testray results.");
        javaExec.setGroup(TESTRAY_CONFIGURATION_NAME);
        javaExec.setMain("com.liferay.jenkins.results.parser.testray.DXPCloudClientTestrayImporter");
        return javaExec;
    }

    private void _configureTaskImportTestrayResults(JavaExec javaExec, TestrayExtension testrayExtension) {
        this._populateSystemProperties(javaExec.getSystemProperties(), this._getTestrayProperties(testrayExtension));
    }

    private File _getExtPropertiesFile(File propertiesFile) {
        String fileName = propertiesFile.getName();
        int pos = fileName.lastIndexOf(46);
        if (pos <= 0) {
            return new File(propertiesFile.getParentFile(), fileName + "-ext");
        }
        String extension = fileName.substring(pos + 1);
        String shortFileName = fileName.substring(0, fileName.length() - extension.length() - 1);
        return new File(propertiesFile.getParentFile(), shortFileName + "-ext." + extension);
    }

    private FileCollection _getTestrayClasspath(Project project) {
        Configuration testrayConfiguration = GradleUtil.getConfiguration((Project)project, (String)TESTRAY_CONFIGURATION_NAME);
        return project.files(new Object[]{testrayConfiguration});
    }

    private Properties _getTestrayProperties(TestrayExtension testrayExtension) {
        Properties testrayProperties = new Properties();
        File testrayPropertiesFile = testrayExtension.getTestrayPropertiesFile();
        if (testrayPropertiesFile == null || !testrayPropertiesFile.exists()) {
            return testrayProperties;
        }
        testrayProperties = GUtil.loadProperties((File)testrayPropertiesFile);
        File testrayExtPropertiesFile = this._getExtPropertiesFile(testrayPropertiesFile);
        if (testrayExtPropertiesFile.exists()) {
            testrayProperties.putAll((Map<?, ?>)GUtil.loadProperties((File)testrayExtPropertiesFile));
        }
        return testrayProperties;
    }

    private void _populateSystemProperties(Map<String, Object> systemProperties, Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            systemProperties.put(key, properties.getProperty(key));
        }
    }
}

