/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration;

import com.liferay.gradle.plugins.test.integration.TestIntegrationBasePlugin;
import com.liferay.gradle.plugins.test.integration.TestIntegrationTomcatExtension;
import com.liferay.gradle.plugins.test.integration.internal.util.GradleUtil;
import com.liferay.gradle.plugins.test.integration.internal.util.StringUtil;
import com.liferay.gradle.plugins.test.integration.task.BaseAppServerTask;
import com.liferay.gradle.plugins.test.integration.task.JmxRemotePortSpec;
import com.liferay.gradle.plugins.test.integration.task.ManagerSpec;
import com.liferay.gradle.plugins.test.integration.task.ModuleFrameworkBaseDirSpec;
import com.liferay.gradle.plugins.test.integration.task.SetUpArquillianTask;
import com.liferay.gradle.plugins.test.integration.task.SetUpTestableTomcatTask;
import com.liferay.gradle.plugins.test.integration.task.StartTestableTomcatTask;
import com.liferay.gradle.plugins.test.integration.task.StopTestableTomcatTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.copy.RenameDependencyClosure;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.testing.Test;
import org.gradle.process.JavaForkOptions;

public class TestIntegrationPlugin
implements Plugin<Project> {
    public static final String COPY_TEST_MODULES_TASK_NAME = "copyTestModules";
    public static final String PLUGIN_NAME = "testIntegration";
    public static final String SET_UP_ARQUILLIAN_TASK_NAME = "setUpArquillian";
    public static final String SET_UP_TESTABLE_TOMCAT_TASK_NAME = "setUpTestableTomcat";
    public static final String START_TESTABLE_TOMCAT_TASK_NAME = "startTestableTomcat";
    public static final String STOP_TESTABLE_TOMCAT_TASK_NAME = "stopTestableTomcat";
    public static final String TEST_MODULES_CONFIGURATION_NAME = "testModules";
    private static final String _SKIP_MANAGED_APP_SERVER_FILE_NAME = "skip.managed.app.server";
    private static final Set<File> _startedAppServerBinDirs = new HashSet<File>();
    private static final ReentrantLock _startedAppServersReentrantLock = new ReentrantLock();
    private static final Map<File, Integer> _startedAppServerStopCounters = new HashMap<File, Integer>();

    public void apply(final Project project) {
        GradleUtil.applyPlugin((Project)project, TestIntegrationBasePlugin.class);
        final SourceSet testIntegrationSourceSet = GradleUtil.getSourceSet((Project)project, (String)PLUGIN_NAME);
        final Test testIntegrationTask = (Test)GradleUtil.getTask((Project)project, (String)PLUGIN_NAME);
        final TestIntegrationTomcatExtension testIntegrationTomcatExtension = (TestIntegrationTomcatExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"testIntegrationTomcat", TestIntegrationTomcatExtension.class);
        Configuration testModulesConfiguration = this._addConfigurationTestModules(project);
        Copy copyTestModulesTask = this._addTaskCopyTestModules(project, testModulesConfiguration, testIntegrationTomcatExtension);
        SetUpTestableTomcatTask setUpTestableTomcatTask = this._addTaskSetUpTestableTomcat(project, copyTestModulesTask, testIntegrationTomcatExtension);
        StopTestableTomcatTask stopTestableTomcatTask = this._addTaskStopTestableTomcat(project, testIntegrationTask, testIntegrationTomcatExtension);
        StartTestableTomcatTask startTestableTomcatTask = this._addTaskStartTestableTomcat(project, setUpTestableTomcatTask, stopTestableTomcatTask, testIntegrationTomcatExtension);
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                SetUpArquillianTask setUpArquillianTask = TestIntegrationPlugin.this._addTaskSetUpArquillian(project, testIntegrationSourceSet, testIntegrationTomcatExtension);
                testIntegrationTask.dependsOn(new Object[]{setUpArquillianTask});
            }
        });
        this._configureTaskTestIntegration(testIntegrationTask, testIntegrationSourceSet, testIntegrationTomcatExtension, startTestableTomcatTask);
    }

    private Configuration _addConfigurationTestModules(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)TEST_MODULES_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                TestIntegrationPlugin.this._addDependenciesTestModules(project);
            }
        });
        configuration.setDescription("Configures additional OSGi modules to deploy during integration testing.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesTestModules(Project project) {
        GradleUtil.addDependency((Project)project, (String)TEST_MODULES_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.arquillian.extension.junit.bridge.connector", (String)"1.0.0");
        GradleUtil.addDependency((Project)project, (String)TEST_MODULES_CONFIGURATION_NAME, (String)"com.liferay.portal", (String)"com.liferay.portal.test", (String)"3.0.0");
        GradleUtil.addDependency((Project)project, (String)TEST_MODULES_CONFIGURATION_NAME, (String)"org.apache.aries.jmx", (String)"org.apache.aries.jmx.core", (String)"1.1.7");
    }

    private Copy _addTaskCopyTestModules(Project project, Configuration testModulesConfiguration, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        final Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)COPY_TEST_MODULES_TASK_NAME, Copy.class);
        final RenameDependencyClosure renameDependencyClosure = new RenameDependencyClosure(project, new String[]{testModulesConfiguration.getName()});
        copy.eachFile((Action)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                if (testIntegrationTomcatExtension.isOverwriteCopyTestModules()) {
                    return;
                }
                String fileName = (String)renameDependencyClosure.call((Object)fileCopyDetails.getName());
                File file = new File(copy.getDestinationDir(), fileName);
                if (file.exists()) {
                    fileCopyDetails.exclude();
                }
            }
        });
        copy.from(new Object[]{testModulesConfiguration});
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(testIntegrationTomcatExtension.getModuleFrameworkBaseDir(), "test");
            }
        });
        copy.rename((Closure)renameDependencyClosure);
        copy.setDescription("Copies additional OSGi modules to deploy during integration testing.");
        TaskOutputsInternal taskOutputs = copy.getOutputs();
        taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
        return copy;
    }

    private SetUpArquillianTask _addTaskSetUpArquillian(Project project, final SourceSet testIntegrationSourceSet, TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        SetUpArquillianTask setUpArquillianTask = (SetUpArquillianTask)GradleUtil.addTask((Project)project, (String)SET_UP_ARQUILLIAN_TASK_NAME, SetUpArquillianTask.class);
        setUpArquillianTask.setDescription("Creates the Arquillian container configuration file for this project.");
        setUpArquillianTask.setOutputDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return TestIntegrationPlugin.this._getSrcDir(testIntegrationSourceSet.getResources());
            }
        });
        this._configureJmxRemotePortSpec(setUpArquillianTask, testIntegrationTomcatExtension);
        this._configureManagerSpec(setUpArquillianTask, testIntegrationTomcatExtension);
        return setUpArquillianTask;
    }

    private SetUpTestableTomcatTask _addTaskSetUpTestableTomcat(Project project, Copy copyTestModulesTask, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        final SetUpTestableTomcatTask setUpTestableTomcatTask = (SetUpTestableTomcatTask)GradleUtil.addTask((Project)project, (String)SET_UP_TESTABLE_TOMCAT_TASK_NAME, SetUpTestableTomcatTask.class);
        setUpTestableTomcatTask.dependsOn(new Object[]{copyTestModulesTask});
        setUpTestableTomcatTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                _startedAppServersReentrantLock.lock();
                try {
                    if (_startedAppServerBinDirs.contains(setUpTestableTomcatTask.getBinDir())) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
            }
        });
        setUpTestableTomcatTask.setDescription("Configures the local Liferay Tomcat bundle to run integration tests.");
        setUpTestableTomcatTask.setDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return testIntegrationTomcatExtension.getDir();
            }
        });
        this._configureManagerSpec(setUpTestableTomcatTask, testIntegrationTomcatExtension);
        this._configureModuleFrameworkBaseDirSpec(setUpTestableTomcatTask, testIntegrationTomcatExtension);
        return setUpTestableTomcatTask;
    }

    private StartTestableTomcatTask _addTaskStartTestableTomcat(Project project, SetUpTestableTomcatTask setUpTestableTomcatTask, StopTestableTomcatTask stopTestableTomcatTask, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        StartTestableTomcatTask startTestableTomcatTask = (StartTestableTomcatTask)GradleUtil.addTask((Project)project, (String)START_TESTABLE_TOMCAT_TASK_NAME, StartTestableTomcatTask.class);
        startTestableTomcatTask.dependsOn(new Object[]{setUpTestableTomcatTask});
        Action<Task> action = new Action<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Task task) {
                Project project;
                Gradle gradle;
                StartParameter startParameter;
                StartTestableTomcatTask startTestableTomcatTask = (StartTestableTomcatTask)task;
                File binDir = startTestableTomcatTask.getBinDir();
                boolean started = false;
                _startedAppServersReentrantLock.lock();
                try {
                    if (_startedAppServerBinDirs.contains(binDir)) {
                        started = true;
                    } else {
                        _startedAppServerBinDirs.add(binDir);
                    }
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
                if (!started) {
                    return;
                }
                Logger logger = startTestableTomcatTask.getLogger();
                if (logger.isDebugEnabled()) {
                    logger.debug("Application server {} is already started", (Object)binDir);
                }
                if ((startParameter = (gradle = (project = startTestableTomcatTask.getProject()).getGradle()).getStartParameter()).isParallelProjectExecutionEnabled()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting for application server {} to be reachable", (Object)binDir);
                    }
                    startTestableTomcatTask.waitForReachable();
                }
                throw new StopExecutionException();
            }
        };
        startTestableTomcatTask.doFirst((Action)action);
        startTestableTomcatTask.finalizedBy(new Object[]{stopTestableTomcatTask});
        startTestableTomcatTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                StartTestableTomcatTask startTestableTomcatTask = (StartTestableTomcatTask)task;
                return !startTestableTomcatTask.isReachable();
            }
        });
        startTestableTomcatTask.setDescription("Starts the local Liferay Tomcat bundle.");
        startTestableTomcatTask.setExecutable(this._getTomcatExecutableFileName("catalina"));
        startTestableTomcatTask.setExecutableArgs(Collections.singleton("run"));
        startTestableTomcatTask.setGroup("verification");
        startTestableTomcatTask.setLiferayHome(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return testIntegrationTomcatExtension.getLiferayHome();
            }
        });
        this._configureBaseAppServerTask(startTestableTomcatTask, testIntegrationTomcatExtension);
        return startTestableTomcatTask;
    }

    private StopTestableTomcatTask _addTaskStopTestableTomcat(Project project, Test testIntegrationTask, TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        final StopTestableTomcatTask stopTestableTomcatTask = (StopTestableTomcatTask)GradleUtil.addTask((Project)project, (String)STOP_TESTABLE_TOMCAT_TASK_NAME, StopTestableTomcatTask.class);
        Object action = new Action<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Task task) {
                StopTestableTomcatTask stopTestableTomcatTask = (StopTestableTomcatTask)task;
                File binDir = stopTestableTomcatTask.getBinDir();
                Logger logger = stopTestableTomcatTask.getLogger();
                _startedAppServersReentrantLock.lock();
                try {
                    if (!_startedAppServerBinDirs.contains(binDir)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Application server {} is already stopped", (Object)binDir);
                        }
                        throw new StopExecutionException();
                    }
                    int originalCounter = TestIntegrationPlugin.this._updateStartedAppServerStopCounters(binDir, false);
                    if (originalCounter > 1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Application server {} cannot be stopped now, still {} to execute", (Object)binDir, (Object)(originalCounter - 1));
                        }
                        throw new StopExecutionException();
                    }
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
            }
        };
        stopTestableTomcatTask.doFirst((Action)action);
        action = new Action<Task>(){

            public void execute(Task task) {
                StopTestableTomcatTask setUpTestableTomcatTask = (StopTestableTomcatTask)task;
                _startedAppServersReentrantLock.lock();
                try {
                    _startedAppServerBinDirs.remove(setUpTestableTomcatTask.getBinDir());
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
            }
        };
        stopTestableTomcatTask.doLast((Action)action);
        stopTestableTomcatTask.mustRunAfter(new Object[]{testIntegrationTask});
        stopTestableTomcatTask.setDescription("Stops the local Liferay Tomcat bundle.");
        stopTestableTomcatTask.setExecutable(this._getTomcatExecutableFileName("shutdown"));
        stopTestableTomcatTask.setGroup("verification");
        this._configureBaseAppServerTask(stopTestableTomcatTask, testIntegrationTomcatExtension);
        this._configureModuleFrameworkBaseDirSpec(stopTestableTomcatTask, testIntegrationTomcatExtension);
        Gradle gradle = project.getGradle();
        TaskExecutionGraph taskExecutionGraph = gradle.getTaskGraph();
        Closure<Void> closure = new Closure<Void>((Object)gradle){

            public void doCall(TaskExecutionGraph taskExecutionGraph) {
                if (taskExecutionGraph.hasTask((Task)stopTestableTomcatTask)) {
                    _startedAppServersReentrantLock.lock();
                    try {
                        TestIntegrationPlugin.this._updateStartedAppServerStopCounters(stopTestableTomcatTask.getBinDir(), true);
                    }
                    finally {
                        _startedAppServersReentrantLock.unlock();
                    }
                }
            }
        };
        taskExecutionGraph.whenReady((Closure)closure);
        return stopTestableTomcatTask;
    }

    private void _configureBaseAppServerTask(BaseAppServerTask baseAppServerTask, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        baseAppServerTask.setBinDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(testIntegrationTomcatExtension.getDir(), "bin");
            }
        });
        baseAppServerTask.setCheckPath(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testIntegrationTomcatExtension.getCheckPath();
            }
        });
        baseAppServerTask.setHostName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testIntegrationTomcatExtension.getHostName();
            }
        });
        baseAppServerTask.setPortNumber(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testIntegrationTomcatExtension.getPortNumber();
            }
        });
    }

    private void _configureJmxRemotePortSpec(JmxRemotePortSpec jmxRemotePortSpec, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        jmxRemotePortSpec.setJmxRemotePort(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testIntegrationTomcatExtension.getJmxRemotePort();
            }
        });
    }

    private void _configureManagerSpec(ManagerSpec managerSpec, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        managerSpec.setManagerPassword(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testIntegrationTomcatExtension.getManagerPassword();
            }
        });
        managerSpec.setManagerUserName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testIntegrationTomcatExtension.getManagerUserName();
            }
        });
    }

    private void _configureModuleFrameworkBaseDirSpec(ModuleFrameworkBaseDirSpec moduleFrameworkBaseDirSpec, final TestIntegrationTomcatExtension testIntegrationTomcatExtension) {
        moduleFrameworkBaseDirSpec.setModuleFrameworkBaseDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return testIntegrationTomcatExtension.getModuleFrameworkBaseDir();
            }
        });
    }

    private void _configureTaskSystemProperty(JavaForkOptions javaForkOptions, String key, File file) {
        Map systemProperties = javaForkOptions.getSystemProperties();
        if (!systemProperties.containsKey(key)) {
            systemProperties.put(key, FileUtil.getAbsolutePath((File)file));
        }
    }

    private void _configureTaskTestIntegration(final Test test, final SourceSet testIntegrationSourceSet, final TestIntegrationTomcatExtension testIntegrationTomcatExtension, final StartTestableTomcatTask startTestableTomcatTask) {
        Closure<Task> closure = new Closure<Task>((Object)test.getProject()){

            public Task doCall(Test test) {
                SourceDirectorySet sourceDirectorySet = testIntegrationSourceSet.getResources();
                for (File dir : sourceDirectorySet.getSrcDirs()) {
                    File file = new File(dir, TestIntegrationPlugin._SKIP_MANAGED_APP_SERVER_FILE_NAME);
                    if (!file.exists()) continue;
                    return null;
                }
                return startTestableTomcatTask;
            }
        };
        test.dependsOn(new Object[]{closure});
        test.jvmArgs(new Object[]{"-Djava.net.preferIPv4Stack=true", "-Duser.timezone=GMT"});
        JavaVersion javaVersion = test.getJavaVersion();
        if (javaVersion.isJava11Compatible()) {
            test.jvmArgs(new Object[]{"--add-opens", "java.base/java.lang=ALL-UNNAMED"});
            test.jvmArgs(new Object[]{"--add-opens", "java.base/java.lang.invoke=ALL-UNNAMED"});
            test.jvmArgs(new Object[]{"--add-opens", "java.base/java.lang.reflect=ALL-UNNAMED"});
            test.jvmArgs(new Object[]{"--add-opens", "java.base/java.net=ALL-UNNAMED"});
            test.jvmArgs(new Object[]{"--add-opens", "java.base/sun.net.www.protocol.http=ALL-UNNAMED"});
            test.jvmArgs(new Object[]{"--add-opens", "java.base/sun.util.calendar=ALL-UNNAMED"});
            test.jvmArgs(new Object[]{"--add-opens", "jdk.zipfs/jdk.nio.zipfs=ALL-UNNAMED"});
        }
        Properties systemProperties = System.getProperties();
        for (String propertyName : systemProperties.stringPropertyNames()) {
            if (!propertyName.startsWith("liferay.arquillian.")) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("-D");
            sb.append(propertyName);
            sb.append("=");
            sb.append(systemProperties.get(propertyName));
            test.jvmArgs(new Object[]{sb.toString()});
        }
        Project project = test.getProject();
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                TestIntegrationPlugin.this._configureTaskTestIntegrationEnabled(test, testIntegrationSourceSet);
                TestIntegrationPlugin.this._configureTaskSystemProperty((JavaForkOptions)test, "app.server.tomcat.dir", testIntegrationTomcatExtension.getDir());
            }
        });
    }

    private void _configureTaskTestIntegrationEnabled(Test test, SourceSet testIntegrationSourceSet) {
        Project project = test.getProject();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("excludes", StringUtil.replaceEnding(test.getExcludes(), ".class", ".java"));
        args.put("includes", StringUtil.replaceEnding(test.getIncludes(), ".class", ".java"));
        SourceDirectorySet sourceDirectorySet = testIntegrationSourceSet.getJava();
        for (File dir : sourceDirectorySet.getSrcDirs()) {
            args.put("dir", dir);
            ConfigurableFileTree fileTree = project.fileTree(args);
            if (fileTree.isEmpty()) continue;
            return;
        }
        test.setDependsOn(Collections.emptySet());
        test.setEnabled(false);
    }

    private File _getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    private String _getTomcatExecutableFileName(String fileName) {
        if (OSDetector.isWindows()) {
            fileName = fileName + ".bat";
        }
        return fileName;
    }

    private int _updateStartedAppServerStopCounters(File binDir, boolean increment) {
        int originalCounter = 0;
        if (_startedAppServerStopCounters.containsKey(binDir)) {
            originalCounter = _startedAppServerStopCounters.get(binDir);
        }
        int counter = originalCounter;
        counter = increment ? ++counter : --counter;
        _startedAppServerStopCounters.put(binDir, counter);
        return originalCounter;
    }
}

