/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.test.integration;

import com.liferay.gradle.plugins.test.integration.internal.util.GradleUtil;
import com.liferay.gradle.plugins.test.integration.internal.util.ReflectionUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.util.VersionNumber;

public class TestIntegrationBasePlugin
implements Plugin<Project> {
    public static final String TEST_INTEGRATION_SOURCE_SET_NAME = "testIntegration";
    public static final String TEST_INTEGRATION_TASK_NAME = "testIntegration";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        SourceSet testIntegrationSourceSet = this._addSourceSetTestIntegration(project);
        Test testIntegrationTask = this._addTaskTestIntegration(project, testIntegrationSourceSet);
        this._configureEclipse(project, testIntegrationSourceSet);
        this._configureIdea(project, testIntegrationSourceSet);
        this._configureTaskCheck(testIntegrationTask);
    }

    private SourceSet _addSourceSetTestIntegration(Project project) {
        SourceSet testIntegrationSourceSet = GradleUtil.addSourceSet((Project)project, (String)"testIntegration");
        Configuration testIntegrationCompileConfiguration = GradleUtil.getConfiguration((Project)project, (String)testIntegrationSourceSet.getCompileConfigurationName());
        Configuration testCompileConfiguration = GradleUtil.getConfiguration((Project)project, (String)"testCompile");
        testIntegrationCompileConfiguration.extendsFrom(new Configuration[]{testCompileConfiguration});
        Configuration testIntegrationRuntimeConfiguration = GradleUtil.getConfiguration((Project)project, (String)testIntegrationSourceSet.getRuntimeConfigurationName());
        Configuration testRuntimeConfiguration = GradleUtil.getConfiguration((Project)project, (String)"testRuntime");
        testIntegrationRuntimeConfiguration.extendsFrom(new Configuration[]{testRuntimeConfiguration, testIntegrationCompileConfiguration});
        SourceSet mainSourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        FileCollection compileClasspath = testIntegrationSourceSet.getCompileClasspath();
        testIntegrationSourceSet.setCompileClasspath(compileClasspath.plus((FileCollection)mainSourceSet.getOutput()));
        FileCollection runtimeClasspath = testIntegrationSourceSet.getRuntimeClasspath();
        testIntegrationSourceSet.setRuntimeClasspath(runtimeClasspath.plus((FileCollection)mainSourceSet.getOutput()));
        return testIntegrationSourceSet;
    }

    private Test _addTaskTestIntegration(Project project, final SourceSet testIntegrationSourceSet) {
        final Test test = (Test)GradleUtil.addTask((Project)project, (String)"testIntegration", Test.class);
        test.mustRunAfter(new Object[]{"test"});
        test.setDescription("Runs the integration tests.");
        test.setForkEvery(null);
        test.setGroup("verification");
        ConventionMapping conventionMapping = test.getConventionMapping();
        conventionMapping.map("classpath", (Callable)new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                return testIntegrationSourceSet.getRuntimeClasspath();
            }
        });
        final SourceSetOutput sourceSetOutput = testIntegrationSourceSet.getOutput();
        final Method getClassesDirsMethod = ReflectionUtil.getMethod(sourceSetOutput, "getClassesDirs", new Class[0]);
        if (getClassesDirsMethod != null) {
            Gradle gradle = project.getGradle();
            VersionNumber versionNumber = VersionNumber.parse((String)gradle.getGradleVersion());
            if (versionNumber.getMajor() == 4 && versionNumber.getMinor() < 1) {
                Method setTestClassesDirsMethod = ReflectionUtil.getMethod(test, "setTestClassesDirs", FileCollection.class);
                try {
                    FileCollection testClassesDirs = (FileCollection)getClassesDirsMethod.invoke((Object)sourceSetOutput, new Object[0]);
                    setTestClassesDirsMethod.invoke((Object)test, testClassesDirs);
                }
                catch (Exception e) {
                    throw new GradleException("Unable to set the \"testClassesDirs\" property of " + test, (Throwable)e);
                }
            }
            conventionMapping.map("testClassesDirs", (Callable)new Callable<FileCollection>(){

                @Override
                public FileCollection call() throws Exception {
                    return (FileCollection)getClassesDirsMethod.invoke((Object)sourceSetOutput, new Object[0]);
                }
            });
        } else {
            conventionMapping.map("testClassesDir", (Callable)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return sourceSetOutput.getClassesDir();
                }
            });
        }
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Set includes = test.getIncludes();
                if (includes.isEmpty()) {
                    test.setIncludes(Collections.singleton("**/*Test.class"));
                }
            }
        });
        return test;
    }

    private void _configureEclipse(final Project project, final SourceSet testIntegrationSourceSet) {
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(EclipsePlugin.class, (Action)new Action<EclipsePlugin>(){

            public void execute(EclipsePlugin eclipsePlugin) {
                TestIntegrationBasePlugin.this._configureEclipseClasspath(project, testIntegrationSourceSet);
            }
        });
    }

    private void _configureEclipseClasspath(Project project, SourceSet testIntegrationSourceSet) {
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        Collection plusConfigurations = eclipseClasspath.getPlusConfigurations();
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)testIntegrationSourceSet.getRuntimeConfigurationName());
        plusConfigurations.add(configuration);
    }

    private void _configureIdea(final Project project, final SourceSet testIntegrationSourceSet) {
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(IdeaPlugin.class, (Action)new Action<IdeaPlugin>(){

            public void execute(IdeaPlugin ideaPlugin) {
                TestIntegrationBasePlugin.this._configureIdeaModule(project, testIntegrationSourceSet);
            }
        });
    }

    private void _configureIdeaModule(Project project, final SourceSet testIntegrationSourceSet) {
        IdeaModel ideaModel = (IdeaModel)GradleUtil.getExtension((ExtensionAware)project, IdeaModel.class);
        final IdeaModule ideaModule = ideaModel.getModule();
        Map scopes = ideaModule.getScopes();
        Map testScope = (Map)scopes.get("TEST");
        Collection plusConfigurations = (Collection)testScope.get("plus");
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)testIntegrationSourceSet.getRuntimeConfigurationName());
        plusConfigurations.add(configuration);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LinkedHashSet testSrcDirs = new LinkedHashSet(ideaModule.getTestSourceDirs());
                SourceDirectorySet sourceDirectorySet = testIntegrationSourceSet.getAllSource();
                testSrcDirs.addAll(sourceDirectorySet.getSrcDirs());
                ideaModule.setTestSourceDirs(testSrcDirs);
            }
        });
    }

    private void _configureTaskCheck(Test test) {
        Project project = test.getProject();
        Task task = GradleUtil.getTask((Project)project, (String)"check");
        task.dependsOn(new Object[]{test});
    }
}

