/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.target.platform.task;

import aQute.bnd.build.Project;
import aQute.bnd.build.model.clauses.HeaderClause;
import aQute.bnd.build.model.conversions.Converter;
import aQute.bnd.gradle.AbstractBndrun;
import aQute.bnd.gradle.BndUtils;
import aQute.service.reporter.Report;
import biz.aQute.resolve.Bndrun;
import biz.aQute.resolve.ResolveProcess;
import com.liferay.gradle.plugins.target.platform.internal.util.GradleUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.osgi.service.resolver.ResolutionException;

public class ResolveTask
extends AbstractBndrun {
    private static final Converter<List<String>, Collection<? extends HeaderClause>> _runbundlesFormatter = new Converter<List<String>, Collection<? extends HeaderClause>>(){

        public List<String> convert(Collection<? extends HeaderClause> input) throws IllegalArgumentException {
            Stream<? extends HeaderClause> stream = input.stream();
            return stream.map(HeaderClause::toString).collect(Collectors.toList());
        }

        public List<String> error(String msg) {
            return null;
        }
    };
    private FileCollection _distroFileCollection;
    private Object _failOnChanges = Boolean.FALSE;
    private Object _offline;
    private Object _reportOptional = Boolean.TRUE;
    private List<String> _runBundles = Collections.emptyList();

    @Deprecated
    @InputFile
    public File getBndrunFile() {
        RegularFileProperty regularFileProperty = this.getBndrun();
        return GradleUtil.toFile((org.gradle.api.Project)this.getProject(), (Object)regularFileProperty.get());
    }

    @InputFile
    public File getDistroFile() {
        return this._distroFileCollection.getSingleFile();
    }

    public MapProperty<String, Object> getProperties() {
        org.gradle.api.Project project = this.getProject();
        ObjectFactory objects = project.getObjects();
        MapProperty mapProperty = objects.mapProperty(String.class, Object.class);
        mapProperty.put((Object)"project", (Object)project);
        Map properties = project.getProperties();
        Map bundle = (Map)properties.get("bundle");
        for (Map.Entry stringObjectEntry : bundle.entrySet()) {
            mapProperty.put((Object)String.format("project.bundle.%s", stringObjectEntry.getKey()), stringObjectEntry.getValue());
        }
        File distroFile = this.getDistroFile();
        mapProperty.put((Object)"targetPlatformDistro", (Object)(distroFile.getAbsolutePath() + ";version=file"));
        mapProperty.putAll((Provider)super.getProperties());
        return mapProperty;
    }

    @Input
    public List<String> getRunBundles() {
        return this._runBundles;
    }

    @Input
    public boolean isFailOnChanges() {
        return GradleUtil.toBoolean(this._failOnChanges);
    }

    @Deprecated
    @Input
    public boolean isOffline() {
        return GradleUtil.toBoolean(this._offline);
    }

    @Input
    public boolean isReportOptional() {
        return GradleUtil.toBoolean(this._reportOptional);
    }

    @Deprecated
    public void resolve() throws Exception {
    }

    @Deprecated
    public void setBndrunFile(Object bndrunFile) {
        RegularFileProperty regularFileProperty = this.getBndrun();
        regularFileProperty.set(GradleUtil.toFile((org.gradle.api.Project)this.getProject(), (Object)bndrunFile));
    }

    public void setDistro(FileCollection distroFileCollection) {
        this._distroFileCollection = distroFileCollection;
    }

    public void setFailOnChanges(Object failOnChanges) {
        this._failOnChanges = failOnChanges;
    }

    @Deprecated
    public void setOffline(Object offline) {
        this._offline = offline;
    }

    public void setReportOptional(Object reportOptional) {
        this._reportOptional = reportOptional;
    }

    protected void worker(Project run) throws Exception {
        if (!(run instanceof Bndrun)) {
            throw new GradleException("Resolving a project's bnd.bnd file is not supported by this task. This task can only resolve a bndrun file.");
        }
        this._worker((Bndrun)run);
    }

    private void _worker(Bndrun bndrun) throws Exception {
        Logger logger = this.getLogger();
        try {
            logger.info("Resolving bundles required for {}", (Object)bndrun.getPropertiesFile());
            this._runBundles = (List)bndrun.resolve(this.isFailOnChanges(), false, _runbundlesFormatter);
            Stream stream = this._runBundles.stream();
            logger.lifecycle("{}:\n    {}", new Object[]{"-runbundles", stream.collect(Collectors.joining("\n    "))});
        }
        catch (ResolutionException resolutionException) {
            logger.error(ResolveProcess.format((ResolutionException)resolutionException, (boolean)this.isReportOptional()));
            throw new GradleException(bndrun.getPropertiesFile() + " resolution exception", (Throwable)resolutionException);
        }
        finally {
            BndUtils.logReport((Report)bndrun, (Logger)logger);
        }
        if (!bndrun.isOk()) {
            throw new GradleException(bndrun.getPropertiesFile() + " resolution failure");
        }
    }
}

