/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.target.platform;

import com.liferay.gradle.plugins.target.platform.TargetPlatformPlugin;
import com.liferay.gradle.plugins.target.platform.extensions.TargetPlatformIDEExtension;
import com.liferay.gradle.plugins.target.platform.internal.util.GradleUtil;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.internal.GeneratedIdeaScope;

public class TargetPlatformIDEPlugin
implements Plugin<Project> {
    public static final String PLUGIN_NAME = "targetPlatformIDE";
    public static final String TARGET_PLATFORM_IDE_CONFIGURATION_NAME = "targetPlatformIDE";
    private static final String _TARGET_PLATFORM_IDE_BOMS_CONFIGURATION_NAME = "targetPlatformIDEBoms";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, IdeaPlugin.class);
        GradleUtil.applyPlugin((Project)project, JavaLibraryPlugin.class);
        GradleUtil.applyPlugin((Project)project, TargetPlatformPlugin.class);
        Configuration targetPlatformIDEConfiguration = this._addConfigurationTargetPlatformIDE(project);
        TargetPlatformIDEExtension targetPlatformIDEExtension = (TargetPlatformIDEExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"targetPlatformIDE", TargetPlatformIDEExtension.class);
        if (targetPlatformIDEExtension.isIndexSources()) {
            this._configureEclipseModel(project, targetPlatformIDEConfiguration);
            this._configureIdeaModel(project, targetPlatformIDEConfiguration);
        }
    }

    private Configuration _addConfigurationTargetPlatformIDE(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)"targetPlatformIDE");
        final Configuration ideBomsConfiguration = GradleUtil.addConfiguration((Project)project, (String)_TARGET_PLATFORM_IDE_BOMS_CONFIGURATION_NAME);
        Configuration bomsConfiguration = GradleUtil.getConfiguration((Project)project, (String)"targetPlatformBoms");
        DependencySet bomsDependencySet = bomsConfiguration.getDependencies();
        bomsDependencySet.all((Action)new Action<Dependency>(){

            public void execute(Dependency dependency) {
                StringBuilder sb = new StringBuilder();
                sb.append(dependency.getGroup());
                sb.append(':');
                sb.append(dependency.getName());
                sb.append(':');
                sb.append(dependency.getVersion());
                sb.append("@pom");
                GradleUtil.addDependency((Project)project, (String)TargetPlatformIDEPlugin._TARGET_PLATFORM_IDE_BOMS_CONFIGURATION_NAME, (String)sb.toString());
            }
        });
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                TargetPlatformIDEPlugin.this._addDependenciesTargetPlatformIDE(project, ideBomsConfiguration);
            }
        });
        configuration.setDescription("Configures all the managed dependencies for the configured Liferay target platform.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesTargetPlatformIDE(Project project, Configuration ideBomsConfiguration) {
        Set bomFiles = ideBomsConfiguration.resolve();
        for (File bomFile : bomFiles) {
            try {
                XmlSlurper xmlSlurper = new XmlSlurper();
                GPathResult gPathResult2 = xmlSlurper.parse(bomFile);
                gPathResult2 = (GPathResult)gPathResult2.getProperty("dependencyManagement");
                gPathResult2 = (GPathResult)gPathResult2.getProperty("dependencies");
                gPathResult2 = (GPathResult)gPathResult2.getProperty("dependency");
                for (GPathResult gPathResult2 : gPathResult2) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(gPathResult2.getProperty("groupId"));
                    sb.append(':');
                    sb.append(gPathResult2.getProperty("artifactId"));
                    sb.append(':');
                    sb.append(gPathResult2.getProperty("version"));
                    GradleUtil.addDependency((Project)project, (String)"targetPlatformIDE", (String)sb.toString());
                }
            }
            catch (Exception exception) {
                Logger logger = project.getLogger();
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Unable to add BOM dependencies from {}", (Object)bomFile);
            }
        }
    }

    private void _configureEclipseModel(Project project, Configuration targetPlatformIDEConfiguration) {
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        eclipseClasspath.setDownloadJavadoc(false);
        Collection plusConfigurations = eclipseClasspath.getPlusConfigurations();
        plusConfigurations.add(targetPlatformIDEConfiguration);
    }

    private void _configureIdeaModel(Project project, Configuration targetPlatformIDEConfiguration) {
        ArrayList<Configuration> plus;
        IdeaModel ideaModel = (IdeaModel)GradleUtil.getExtension((ExtensionAware)project, IdeaModel.class);
        IdeaModule ideaModule = ideaModel.getModule();
        Map scopes = ideaModule.getScopes();
        HashMap<String, ArrayList<Configuration>> providedScope = (HashMap<String, ArrayList<Configuration>>)scopes.get(GeneratedIdeaScope.PROVIDED.name());
        if (providedScope == null) {
            providedScope = new HashMap<String, ArrayList<Configuration>>();
        }
        if ((plus = (ArrayList<Configuration>)providedScope.get("plus")) == null) {
            plus = new ArrayList<Configuration>();
        }
        plus.add(targetPlatformIDEConfiguration);
        providedScope.put("plus", plus);
        scopes.put(GeneratedIdeaScope.PROVIDED.name(), providedScope);
        ideaModule.setScopes(scopes);
        SourceSet mainSourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        FileCollection compileClasspath = mainSourceSet.getCompileClasspath();
        compileClasspath.plus((FileCollection)targetPlatformIDEConfiguration);
    }
}

