/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.source.formatter;

import com.liferay.gradle.plugins.source.formatter.FormatSourceTask;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;

public class SourceFormatterPlugin
implements Plugin<Project> {
    public static final String CHECK_SOURCE_FORMATTING_TASK_NAME = "checkSourceFormatting";
    public static final String CONFIGURATION_NAME = "sourceFormatter";
    public static final String FORMAT_SOURCE_TASK_NAME = "formatSource";

    public void apply(Project project) {
        Configuration sourceFormatterConfiguration = this._addConfigurationSourceFormatter(project);
        this._addTaskCheckSourceFormatting(project);
        this._addTaskFormatSource(project);
        this._configureTasksFormatSource(project, (FileCollection)sourceFormatterConfiguration);
    }

    private Configuration _addConfigurationSourceFormatter(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                SourceFormatterPlugin.this._addDependenciesSourceFormatter(project);
            }
        });
        configuration.setDescription("Configures Liferay Source Formatter for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesSourceFormatter(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.source.formatter", (String)"latest.release");
    }

    private FormatSourceTask _addTaskCheckSourceFormatting(Project project) {
        FormatSourceTask formatSourceTask = (FormatSourceTask)GradleUtil.addTask((Project)project, (String)CHECK_SOURCE_FORMATTING_TASK_NAME, FormatSourceTask.class);
        formatSourceTask.setAutoFix(false);
        formatSourceTask.setDescription("Checks the source formatting of this project.");
        formatSourceTask.setGroup("verification");
        formatSourceTask.setPrintErrors(true);
        formatSourceTask.setThrowException(true);
        return formatSourceTask;
    }

    private FormatSourceTask _addTaskFormatSource(Project project) {
        FormatSourceTask formatSourceTask = (FormatSourceTask)GradleUtil.addTask((Project)project, (String)FORMAT_SOURCE_TASK_NAME, FormatSourceTask.class);
        formatSourceTask.setDescription("Runs Liferay Source Formatter to format the project files.");
        formatSourceTask.setGroup("formatting");
        return formatSourceTask;
    }

    private void _configureTaskFormatSource(FormatSourceTask formatSourceTask, FileCollection classpath) {
        String formatLocalChanges;
        String formatLatestAuthor;
        formatSourceTask.setClasspath(classpath);
        String formatCurrentBranch = GradleUtil.getTaskPrefixedProperty((Task)formatSourceTask, (String)"format.current.branch");
        if (Validator.isNotNull((String)formatCurrentBranch)) {
            formatSourceTask.setFormatCurrentBranch(Boolean.parseBoolean(formatCurrentBranch));
        }
        if (Validator.isNotNull((String)(formatLatestAuthor = GradleUtil.getTaskPrefixedProperty((Task)formatSourceTask, (String)"format.latest.author")))) {
            formatSourceTask.setFormatLatestAuthor(Boolean.parseBoolean(formatLatestAuthor));
        }
        if (Validator.isNotNull((String)(formatLocalChanges = GradleUtil.getTaskPrefixedProperty((Task)formatSourceTask, (String)"format.local.changes")))) {
            formatSourceTask.setFormatLocalChanges(Boolean.parseBoolean(formatLocalChanges));
        }
    }

    private void _configureTasksFormatSource(Project project, final FileCollection classpath) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FormatSourceTask.class, (Action)new Action<FormatSourceTask>(){

            public void execute(FormatSourceTask formatSourceTask) {
                SourceFormatterPlugin.this._configureTaskFormatSource(formatSourceTask, classpath);
            }
        });
    }
}

