/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.source.formatter;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.JavaExec;
import org.gradle.process.JavaExecSpec;

public class FormatSourceTask
extends JavaExec {
    private final SourceFormatterArgs _sourceFormatterArgs = new SourceFormatterArgs();

    public JavaExecSpec args(Iterable<?> args) {
        throw new UnsupportedOperationException();
    }

    public JavaExec args(Object ... args) {
        throw new UnsupportedOperationException();
    }

    public JavaExec classpath(Object ... paths) {
        throw new UnsupportedOperationException();
    }

    public void exec() {
        super.setArgs(this.getArgs());
        super.setClasspath(this.getClasspath());
        super.setWorkingDir((Object)this.getWorkingDir());
        super.exec();
    }

    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("source.auto.fix=" + this.isAutoFix());
        args.add("source.copyright.file=" + FileUtil.getAbsolutePath((File)this.getCopyrightFile()));
        args.add("source.print.errors=" + this.isPrintErrors());
        args.add("source.throw.exception=" + this.isThrowException());
        args.add("source.use.properties=" + this.isUseProperties());
        FileCollection fileCollection = this.getFiles();
        if (fileCollection.isEmpty()) {
            args.add("source.base.dir=" + FileUtil.getAbsolutePath((File)this.getBaseDir()));
        } else {
            args.add("source.files=" + this._merge((Iterable<File>)fileCollection));
        }
        return args;
    }

    public File getBaseDir() {
        Project project = this.getProject();
        return project.file((Object)this._sourceFormatterArgs.getBaseDirName());
    }

    public FileCollection getClasspath() {
        return GradleUtil.getConfiguration((Project)this.getProject(), (String)"sourceFormatter");
    }

    public File getCopyrightFile() {
        Project project = this.getProject();
        return project.file((Object)this._sourceFormatterArgs.getCopyrightFileName());
    }

    public FileCollection getFiles() {
        Project project = this.getProject();
        List<String> fileNames = this._sourceFormatterArgs.getFileNames();
        if (fileNames == null) {
            fileNames = Collections.emptyList();
        }
        return project.files(new Object[]{fileNames});
    }

    public String getMain() {
        return "com.liferay.source.formatter.SourceFormatter";
    }

    public File getWorkingDir() {
        Project project = this.getProject();
        return project.getProjectDir();
    }

    public boolean isAutoFix() {
        return this._sourceFormatterArgs.isAutoFix();
    }

    public boolean isPrintErrors() {
        return this._sourceFormatterArgs.isPrintErrors();
    }

    public boolean isThrowException() {
        return this._sourceFormatterArgs.isThrowException();
    }

    public boolean isUseProperties() {
        return this._sourceFormatterArgs.isUseProperties();
    }

    public void setBaseDirName(String baseDirName) {
        this._sourceFormatterArgs.setBaseDirName(baseDirName);
    }

    public void setCopyrightFileName(String copyrightFileName) {
        this._sourceFormatterArgs.setCopyrightFileName(copyrightFileName);
    }

    public void setFileNames(String[] fileNames) {
        this._sourceFormatterArgs.setFileNames(Arrays.asList(fileNames));
    }

    public void setPrintErrors(boolean printErrors) {
        this._sourceFormatterArgs.setPrintErrors(printErrors);
    }

    public void setThrowException(boolean throwException) {
        this._sourceFormatterArgs.setThrowException(throwException);
    }

    public void setUseProperties(boolean useProperties) {
        this._sourceFormatterArgs.setUseProperties(useProperties);
    }

    private String _merge(Iterable<File> files) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (File file : files) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(FileUtil.getAbsolutePath((File)file));
            ++i;
        }
        return sb.toString();
    }
}

