/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.lang.builder;

import com.liferay.gradle.plugins.lang.builder.BuildLangTask;
import com.liferay.gradle.plugins.lang.builder.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class LangBuilderPlugin
implements Plugin<Project> {
    public static final String APP_BUILD_LANG_TASK_NAME = "appBuildLang";
    public static final String BUILD_LANG_TASK_NAME = "buildLang";
    public static final String CONFIGURATION_NAME = "langBuilder";

    public void apply(Project project) {
        Configuration langBuilderConfiguration = this._addConfigurationLangBuilder(project);
        BuildLangTask buildLangTask = this._addTaskBuildLang(project);
        this._configureTaskBuildLang(buildLangTask);
        this._configureTaskProcessResources(project);
        this._configureTasksBuildLang(project, langBuilderConfiguration);
    }

    private Configuration _addConfigurationLangBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                LangBuilderPlugin.this._addDependenciesLangBuilder(project);
            }
        });
        configuration.setDescription("Configures Liferay Lang Builder for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesLangBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.lang.builder", (String)"latest.release");
    }

    private BuildLangTask _addTaskAppBuildLang(Project project, File appLangFile) {
        BuildLangTask buildLangTask = (BuildLangTask)GradleUtil.addTask((Project)project, (String)APP_BUILD_LANG_TASK_NAME, BuildLangTask.class);
        buildLangTask.setDescription("Runs Liferay Lang Builder to translate language property files for the app.");
        buildLangTask.setLangDir(appLangFile.getParentFile());
        buildLangTask.setLangFileName("bundle");
        return buildLangTask;
    }

    private BuildLangTask _addTaskBuildLang(Project project) {
        final BuildLangTask buildLangTask = (BuildLangTask)GradleUtil.addTask((Project)project, (String)BUILD_LANG_TASK_NAME, BuildLangTask.class);
        buildLangTask.setDescription("Runs Liferay Lang Builder to translate language property files.");
        buildLangTask.setGroup("build");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                LangBuilderPlugin.this._configureTaskBuildLangForJavaPlugin(buildLangTask);
            }
        });
        return buildLangTask;
    }

    private void _configureTaskBuildLang(BuildLangTask buildLangTask) {
        File appLangFile;
        Project project = buildLangTask.getProject();
        Project appProject = GradleUtil.getAppProject(project);
        if (appProject != null && (appLangFile = new File(appProject.getProjectDir(), "app.bnd-localization/bundle.properties")).exists()) {
            BuildLangTask appBuildLangTask = null;
            appBuildLangTask = GradleUtil.hasTask(appProject, APP_BUILD_LANG_TASK_NAME) ? (BuildLangTask)GradleUtil.getTask((Project)appProject, (String)APP_BUILD_LANG_TASK_NAME) : this._addTaskAppBuildLang(appProject, appLangFile);
            buildLangTask.dependsOn(new Object[]{appBuildLangTask});
        }
    }

    private void _configureTaskBuildLangClasspath(BuildLangTask buildLangTask, FileCollection fileCollection) {
        buildLangTask.setClasspath(fileCollection);
        Project project = buildLangTask.getProject();
        Project appProject = GradleUtil.getAppProject(project);
        if (appProject != null && GradleUtil.hasTask(appProject, APP_BUILD_LANG_TASK_NAME)) {
            BuildLangTask appBuildLangTask = (BuildLangTask)GradleUtil.getTask((Project)appProject, (String)APP_BUILD_LANG_TASK_NAME);
            appBuildLangTask.setClasspath(fileCollection);
        }
    }

    private void _configureTaskBuildLangForJavaPlugin(final BuildLangTask buildLangTask) {
        buildLangTask.setLangDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(LangBuilderPlugin.this._getResourcesDir(buildLangTask.getProject()), "content");
            }
        });
    }

    private void _configureTaskProcessResources(Project project) {
        File appDir = GradleUtil.getRootDir((Project)project, (String)"app.bnd");
        final File appBndLocalizationDir = new File(appDir, "app.bnd-localization");
        if (!appBndLocalizationDir.exists()) {
            return;
        }
        final Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"processResources");
        final HashMap<String, String> relengProperties = new HashMap<String, String>();
        Map projectProperties = project.getProperties();
        for (Map.Entry entry : projectProperties.entrySet()) {
            String key;
            Object value = entry.getValue();
            if (!(value instanceof String) || !(key = (String)entry.getKey()).startsWith("liferay.releng")) continue;
            relengProperties.put("${" + key + "}", (String)value);
        }
        Action<FileCopyDetails> action = new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter((Closure)new Closure<Void>((Object)copy){

                    public String doCall(String line) {
                        if (Validator.isNull((String)line)) {
                            return line;
                        }
                        for (Map.Entry entry : relengProperties.entrySet()) {
                            line = line.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                        }
                        return line;
                    }
                });
            }
        };
        copy.from((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return appBndLocalizationDir;
            }
        }, (Closure)new Closure<Void>((Object)project, (Action)action){
            final /* synthetic */ Action val$action;
            {
                this.val$action = action;
                super(x0);
            }

            public void doCall(CopySpec copySpec) {
                copySpec.eachFile(this.val$action);
                copySpec.into((Object)"OSGI-INF/l10n");
            }
        });
    }

    private void _configureTasksBuildLang(Project project, final Configuration langBuilderConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildLangTask.class, (Action)new Action<BuildLangTask>(){

            public void execute(BuildLangTask buildLangTask) {
                LangBuilderPlugin.this._configureTaskBuildLangClasspath(buildLangTask, (FileCollection)langBuilderConfiguration);
            }
        });
    }

    private File _getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this._getSrcDir(sourceSet.getResources());
    }

    private File _getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

