/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.task;

import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class WritePropertiesTask
extends DefaultTask {
    private final List<KeyValuePair> _keyValuePairs = new ArrayList<KeyValuePair>();
    private Object _outputFile;

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    @Input
    @SkipWhenEmpty
    public Map<String, Object> getProperties() {
        TreeMap<String, Object> properties = new TreeMap<String, Object>();
        for (KeyValuePair keyValuePair : this._keyValuePairs) {
            String key = GradleUtil.toString((Object)keyValuePair.key);
            properties.put(key, keyValuePair.value);
        }
        return properties;
    }

    public WritePropertiesTask properties(Map<String, ?> properties) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this._keyValuePairs.add(new KeyValuePair(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    public WritePropertiesTask property(Object key, Object value) {
        this._keyValuePairs.add(new KeyValuePair(key, value));
        return this;
    }

    public WritePropertiesTask property(String key, Object value) {
        return this.property((Object)key, value);
    }

    public void setOutputFile(Object outputFile) {
        this._outputFile = outputFile;
    }

    public void setProperties(Map<String, ?> properties) {
        this._keyValuePairs.clear();
        this.properties(properties);
    }

    @TaskAction
    public void writeProperties() throws IOException {
        FileUtil.writeProperties(this.getOutputFile(), this.getProperties());
    }

    private static class KeyValuePair {
        public final Object key;
        public final Object value;

        public KeyValuePair(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

