/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.github.maiflai.ScalaTestPlugin;
import com.liferay.gradle.plugins.SourceFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import java.io.File;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.scala.ScalaPlugin;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.logging.TestExceptionFormat;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.scala.tasks.AbstractScalaCompile;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.idea.IdeaPlugin;

public class LiferayScalaDefaultsPlugin
implements Plugin<Project> {
    private static final String _GROUP = "com.liferay";

    public void apply(Project project) {
        this._applyPlugins(project);
        File portalRootDir = GradleUtil.getRootDir((Project)project.getRootProject(), (String)"portal-impl");
        GradlePluginsDefaultsUtil.configureRepositories(project, portalRootDir);
        this._configureProject(project);
        this._configureTaskCompileScala(project);
        this._configureTaskJar(project);
        this._configureTaskTest(project);
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, IdeaPlugin.class);
        GradleUtil.applyPlugin((Project)project, ScalaPlugin.class);
        GradleUtil.applyPlugin((Project)project, ScalaTestPlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterDefaultsPlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
    }

    private void _configureProject(Project project) {
        project.setGroup((Object)GradleUtil.getProjectGroup(project, _GROUP));
    }

    private void _configureTaskCompileScala(Project project) {
        AbstractScalaCompile abstractScalaCompile = (AbstractScalaCompile)GradleUtil.fetchTask((Project)project, (String)"compileScala");
        if (abstractScalaCompile != null) {
            abstractScalaCompile.setSourceCompatibility(JavaVersion.VERSION_1_8.toString());
            abstractScalaCompile.setTargetCompatibility(JavaVersion.VERSION_1_8.toString());
        }
    }

    private void _configureTaskJar(final Project project) {
        Jar jarTask = (Jar)GradleUtil.fetchTask((Project)project, (String)"jar");
        if (jarTask != null) {
            jarTask.exclude(new String[]{"META-INF/*.DSA", "META-INF/*.RSA", "META-INF/*.SF"});
            jarTask.from(new Object[]{new Callable<FileTree>(){

                @Override
                public FileTree call() throws Exception {
                    ConfigurableFileCollection files = project.files(new Object[0]);
                    ConfigurationContainer configurationContainer = project.getConfigurations();
                    Configuration compileConfiguration = configurationContainer.getByName("compile");
                    for (File file : compileConfiguration) {
                        if (file.isDirectory()) {
                            files = files.plus((FileCollection)project.files(new Object[]{file}));
                            continue;
                        }
                        files = files.plus((FileCollection)project.zipTree((Object)file));
                    }
                    return files.getAsFileTree();
                }
            }});
        }
    }

    private void _configureTaskTest(Project project) {
        Test test = (Test)GradleUtil.fetchTask((Project)project, (String)"test");
        if (test != null) {
            test.setIgnoreFailures(false);
            TestLoggingContainer testLoggingContainer = test.getTestLogging();
            HashSet<TestLogEvent> testLogEvents = new HashSet<TestLogEvent>();
            testLogEvents.add(TestLogEvent.FAILED);
            testLogEvents.add(TestLogEvent.PASSED);
            testLogEvents.add(TestLogEvent.SKIPPED);
            testLogEvents.add(TestLogEvent.STANDARD_ERROR);
            testLogEvents.add(TestLogEvent.STARTED);
            testLoggingContainer.setEvents(testLogEvents);
            testLoggingContainer.setExceptionFormat(TestExceptionFormat.FULL);
            testLoggingContainer.setShowCauses(true);
            testLoggingContainer.setShowExceptions(true);
            testLoggingContainer.setShowStackTraces(true);
        }
    }
}

