/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.util.PortalTools;
import java.util.Collections;
import java.util.EnumSet;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.logging.TestExceptionFormat;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.jvm.tasks.Jar;

public class JavaDefaultsPlugin
extends BaseDefaultsPlugin<JavaPlugin> {
    public static final Plugin<Project> INSTANCE = new JavaDefaultsPlugin();

    protected void configureDefaults(Project project, JavaPlugin javaPlugin) {
        String portalVersion = PortalTools.getPortalVersion((Project)project);
        this._configureTasksJar(project, portalVersion);
        this._configureTasksTest(project);
    }

    protected Class<JavaPlugin> getPluginClass() {
        return JavaPlugin.class;
    }

    private JavaDefaultsPlugin() {
    }

    private void _configureTaskJarEnabled(Jar jar, String portalVersion) {
        if ("7.0.x".equals(portalVersion)) {
            return;
        }
        Project project = jar.getProject();
        String name = project.getName();
        if (name.endsWith("-test")) {
            jar.setEnabled(false);
        }
    }

    private void _configureTasksJar(Project project, final String portalVersion) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Jar.class, (Action)new Action<Jar>(){

            public void execute(Jar jar) {
                String taskName = jar.getName();
                if (taskName.startsWith("jar")) {
                    JavaDefaultsPlugin.this._configureTaskJarEnabled(jar, portalVersion);
                }
            }
        });
    }

    private void _configureTasksTest(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                String taskName = test.getName();
                if (taskName.startsWith("test")) {
                    JavaDefaultsPlugin.this._configureTaskTestLogging(test);
                }
            }
        });
    }

    private void _configureTaskTestLogging(Test test) {
        TestLoggingContainer testLoggingContainer = test.getTestLogging();
        testLoggingContainer.setEvents(EnumSet.allOf(TestLogEvent.class));
        testLoggingContainer.setExceptionFormat(TestExceptionFormat.FULL);
        testLoggingContainer.setStackTraceFilters(Collections.emptyList());
    }
}

