/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util.copy;

import com.liferay.gradle.util.Validator;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCopyDetails;

public class RenameDependencyAction
implements Action<FileCopyDetails> {
    private static final Pattern _versionStartPattern = Pattern.compile("\\w-\\d.*");
    private final boolean _keepVersion;

    public RenameDependencyAction(boolean keepVersion) {
        this._keepVersion = keepVersion;
    }

    public void execute(FileCopyDetails fileCopyDetails) {
        String fileName = fileCopyDetails.getName();
        if (!fileName.endsWith(".jar")) {
            return;
        }
        int pos = RenameDependencyAction._getVersionStart(fileName);
        if (this._keepVersion == pos < fileName.length() && fileName.lastIndexOf(46, pos) != -1) {
            return;
        }
        try (JarFile jarFile = new JarFile(fileCopyDetails.getFile());){
            fileName = this._getFileName(jarFile);
            fileCopyDetails.setName(fileName);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    private static int _getVersionStart(String name) {
        Matcher matcher = _versionStartPattern.matcher(name);
        if (!matcher.find()) {
            return name.length();
        }
        return matcher.start();
    }

    private String _getFileName(JarFile jarFile) throws IOException {
        int pos;
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            throw new GradleException("Unable to rename " + jarFile.getName() + ", as it does not contain a manifest");
        }
        Attributes attributes = manifest.getMainAttributes();
        String fileName = attributes.getValue("Bundle-SymbolicName");
        if (Validator.isNotNull((String)fileName) && (pos = fileName.indexOf(59)) != -1) {
            fileName = fileName.substring(0, pos);
        }
        if (Validator.isNull((String)fileName) || RenameDependencyAction._getVersionStart(fileName) < fileName.length()) {
            throw new GradleException("Unable to rename " + jarFile.getName() + ", as its manifest does not contain a valid '" + "Bundle-SymbolicName" + "' header");
        }
        if (this._keepVersion) {
            String version = attributes.getValue("Bundle-Version");
            if (Validator.isNull((String)version)) {
                throw new GradleException("Unable to rename " + jarFile.getName() + ", as its manifest does not contain a valid '" + "Bundle-Version" + "' header");
            }
            fileName = fileName + "-" + version;
        }
        fileName = fileName + ".jar";
        return fileName;
    }
}

