/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CopyrightUtil {
    public static String getCopyright(File projectDir) throws IOException {
        return CopyrightUtil._getCopyright(projectDir);
    }

    public static boolean isCommercial(File projectDir) throws IOException {
        Path projectPath = projectDir.toPath();
        if (projectPath == null) {
            return false;
        }
        Path absolutePath = projectPath.toAbsolutePath();
        absolutePath = absolutePath.normalize();
        String absoluteFileName = absolutePath.toString();
        if ((absoluteFileName = absoluteFileName.replace('\\', '/')).contains("/modules/private/apps/")) {
            return true;
        }
        for (File dir = absolutePath.toFile(); dir != null; dir = dir.getParentFile()) {
            File file = new File(dir, "gradle.properties");
            if (!file.exists()) continue;
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            if (!properties.containsKey("project.path.prefix")) continue;
            String s = properties.getProperty("project.path.prefix");
            return s.startsWith(":private:apps");
        }
        return false;
    }

    private static String _getCopyright(File projectDir) throws IOException {
        ClassLoader classLoader = CopyrightUtil.class.getClassLoader();
        String name = "copyright.txt";
        if (CopyrightUtil.isCommercial(projectDir)) {
            name = "copyright-commercial.txt";
        }
        InputStream inputStream = classLoader.getResourceAsStream("com/liferay/gradle/plugins/defaults/dependencies/" + name);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Stream<String> stream = bufferedReader.lines();
        return stream.collect(Collectors.joining("\n"));
    }
}

