/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.util.GUtil;

public class CIUtil {
    public static String getBNDHotfixVersion(Project project, String bndFileName) {
        if (!FileUtil.exists((Project)project, (String)bndFileName)) {
            return null;
        }
        Properties properties = GUtil.loadProperties((File)project.file((Object)bndFileName));
        String version = properties.getProperty("Bundle-Version");
        if (version == null || version.indexOf("hotfix") == -1) {
            return null;
        }
        return version;
    }

    public static String getJSONHotfixVersion(Project project, String jsonFileName) {
        if (!FileUtil.exists((Project)project, (String)jsonFileName)) {
            return null;
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map map = (Map)jsonSlurper.parse(project.file((Object)jsonFileName));
        String version = (String)map.get("version");
        if (version == null || version.indexOf("hotfix") == -1) {
            return null;
        }
        return version;
    }

    public static boolean isExcludedDependencyProject(Project project, Project dependencyProject) {
        File bndFile = project.file((Object)"bnd.bnd");
        if (!Files.exists(bndFile.toPath(), new LinkOption[0])) {
            return false;
        }
        File dependencyBndFile = dependencyProject.file((Object)"bnd.bnd");
        if (!Files.exists(dependencyBndFile.toPath(), new LinkOption[0])) {
            return false;
        }
        Properties dependencyProperties = GUtil.loadProperties((File)dependencyBndFile);
        String dependencyExportPackage = dependencyProperties.getProperty("Export-Package");
        if (Validator.isNotNull((String)dependencyExportPackage)) {
            Properties properties = GUtil.loadProperties((File)bndFile);
            String importPackage = properties.getProperty("Import-Package");
            if (Validator.isNull((String)importPackage)) {
                return false;
            }
            List<String> importPackages = Arrays.asList(importPackage.split(","));
            for (String exportPackage : dependencyExportPackage.split(",")) {
                if (importPackages.contains("!" + exportPackage)) continue;
                return false;
            }
        }
        return true;
    }

    public static void restoreHotfixVersion(Project project, String fileName) {
        int index;
        String hotfixVersion = CIUtil.getBNDHotfixVersion(project, fileName);
        if (fileName.endsWith(".json")) {
            hotfixVersion = CIUtil.getJSONHotfixVersion(project, fileName);
        }
        if (hotfixVersion != null && (index = hotfixVersion.indexOf("-hotfix")) != -1) {
            String suffix = hotfixVersion.substring(index + 7);
            String newHotfixVersion = hotfixVersion.substring(0, index) + ".hotfix" + suffix;
            CIUtil._write(project, fileName, newHotfixVersion, hotfixVersion);
        }
    }

    public static void updateHotfixVersion(Project project, String fileName) {
        int index;
        String hotfixVersion = CIUtil.getBNDHotfixVersion(project, fileName);
        if (fileName.endsWith(".json")) {
            hotfixVersion = CIUtil.getJSONHotfixVersion(project, fileName);
        }
        if (hotfixVersion != null && (index = hotfixVersion.indexOf(".hotfix")) != -1) {
            String suffix = hotfixVersion.substring(index + 7);
            String newHotfixVersion = hotfixVersion.substring(0, index) + "-hotfix" + suffix;
            CIUtil._write(project, fileName, newHotfixVersion, hotfixVersion);
        }
    }

    private static void _write(Project project, String fileName, String newHotfixVersion, String oldHotfixVersion) {
        File file = project.file((Object)fileName);
        try {
            String content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            content = content.replace(oldHotfixVersion, newHotfixVersion);
            Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Logger logger = project.getLogger();
            if (logger.isLifecycleEnabled()) {
                String relativePath = project.relativePath((Object)file);
                logger.lifecycle("Updated {}:{}", new Object[]{relativePath, newHotfixVersion});
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

