/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.SourceFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.Collections;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.springframework.boot.gradle.plugin.SpringBootPlugin;
import org.springframework.boot.gradle.run.BootRunTask;

public class LiferaySpringBootDefaultsPlugin
implements Plugin<Project> {
    private static final String _GROUP = "com.liferay";

    public void apply(Project project) {
        this._applyPlugins(project);
        File portalRootDir = GradleUtil.getRootDir(project.getRootProject(), "portal-impl");
        GradlePluginsDefaultsUtil.configureRepositories(project, portalRootDir);
        this._configureProject(project);
        BootRunTask bootRunTask = (BootRunTask)GradleUtil.getTask((Project)project, (String)"bootRun");
        this._addTaskRun(bootRunTask);
        this._configureTaskBootRun(bootRunTask);
    }

    private Task _addTaskRun(BootRunTask bootRunTask) {
        Project project = bootRunTask.getProject();
        Task task = project.task("run");
        task.dependsOn(new Object[]{bootRunTask});
        task.setDescription("Runs Spring Boot '" + bootRunTask.getName() + "' task.");
        task.setGroup("build");
        return task;
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, IdeaPlugin.class);
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterDefaultsPlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, SpringBootPlugin.class);
    }

    private void _configureProject(Project project) {
        String group = GradleUtil.getGradlePropertiesValue(project, "project.group", _GROUP);
        project.setGroup((Object)group);
    }

    private void _configureTaskBootRun(BootRunTask bootRunTask) {
        String springBootJavaOpts = System.getenv("SPRING_BOOT_JAVA_OPTS");
        if (Validator.isNotNull((String)springBootJavaOpts)) {
            bootRunTask.setJvmArgs(Collections.singleton(springBootJavaOpts));
        }
    }
}

