/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.cache.WriteDigestTask;
import com.liferay.gradle.plugins.defaults.extensions.LiferayThemeDefaultsExtension;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.internal.util.IncrementVersionClosure;
import com.liferay.gradle.plugins.defaults.tasks.ReplaceRegexTask;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.gulp.ExecuteGulpTask;
import com.liferay.gradle.plugins.lang.merger.LangMergerPlugin;
import com.liferay.gradle.plugins.lang.merger.tasks.MergePropertiesTask;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import groovy.lang.Closure;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.util.GUtil;

public class LiferayThemeDefaultsPlugin
implements Plugin<Project> {
    public static final String EXPAND_FRONTEND_CSS_COMMON_TASK_NAME = "expandFrontendCSSCommon";
    public static final String FRONTEND_CSS_COMMON_CONFIGURATION_NAME = "frontendCSSCommon";
    public static final String PLUGIN_NAME = "liferayThemeDefaults";
    public static final String PUBLISH_NODE_MODULE_TASK_NAME = "publishNodeModule";
    public static final String RESTORE_MERGE_LANG_DESTINATION_DIR_TASK_NAME = "restoreMergeLangDestinationDir";
    public static final String SAVE_MERGE_LANG_DESTINATION_DIR_TASK_NAME = "saveMergeLangDestinationDir";
    public static final String WRITE_PARENT_THEMES_DIGEST_TASK_NAME = "writeParentThemesDigest";
    public static final String ZIP_RESOURCES_IMPORTER_ARCHIVES_TASK_NAME = "zipResourcesImporterArchives";
    private static final String _FRONTEND_COMMON_CSS_NAME = "com.liferay.frontend.css.common";
    private static final String _GROUP = "com.liferay.plugins";

    public void apply(final Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayThemePlugin.class);
        this._applyPlugins(project);
        this._addTaskInstall(project);
        this._applyConfigScripts(project);
        final LiferayThemeDefaultsExtension liferayThemeDefaultsExtension = (LiferayThemeDefaultsExtension)GradleUtil.addExtension((ExtensionAware)project, (String)PLUGIN_NAME, LiferayThemeDefaultsExtension.class);
        File portalRootDir = GradleUtil.getRootDir(project.getRootProject(), "portal-impl");
        GradlePluginsDefaultsUtil.configureRepositories(project, portalRootDir);
        Configuration frontendCSSCommonConfiguration = this._addConfigurationFrontendCSSCommon(project);
        final Project frontendThemeStyledProject = this._getThemeProject(project, "frontend-theme-styled");
        final Project frontendThemeUnstyledProject = this._getThemeProject(project, "frontend-theme-unstyled");
        final WriteDigestTask writeDigestTask = this._addTaskWriteParentThemesDigest(project, frontendThemeStyledProject, frontendThemeUnstyledProject);
        final Copy expandFrontendCSSCommonTask = this._addTaskExpandFrontendCSSCommon(project, frontendCSSCommonConfiguration);
        final ReplaceRegexTask updateVersionTask = this._addTaskUpdateVersion(project, writeDigestTask);
        File resourcesImporterArchivesDir = project.file((Object)"src/WEB-INF/src/resources-importer");
        File resourcesImporterExpandedArchivesDir = project.file((Object)"resources-importer");
        Task zipResourcesImporterArchivesTask = this._addTaskZipDirectories(project, ZIP_RESOURCES_IMPORTER_ARCHIVES_TASK_NAME, resourcesImporterExpandedArchivesDir, resourcesImporterArchivesDir, "lar");
        final PublishNodeModuleTask publishNodeModuleTask = this._addTaskPublishNodeModule(zipResourcesImporterArchivesTask);
        this._configureDeployDir(project);
        this._configureProject(project);
        this._configureTasksExecuteGulp(project, zipResourcesImporterArchivesTask);
        GradleUtil.excludeTasksWithProperty(project, "snapshotIfStale", true, "install", "uploadArchives");
        GradleUtil.withPlugin(project, LangMergerPlugin.class, new Action<LangMergerPlugin>(){

            public void execute(LangMergerPlugin langMergerPlugin) {
                LiferayThemeDefaultsPlugin.this._configureLangMerger(project);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                if (liferayThemeDefaultsExtension.isUseLocalDependencies()) {
                    LiferayThemeDefaultsPlugin.this._configureTasksExecuteGulpLocalDependencies(project, expandFrontendCSSCommonTask, frontendThemeStyledProject, frontendThemeUnstyledProject);
                } else {
                    writeDigestTask.setEnabled(false);
                }
                GradlePluginsDefaultsUtil.setProjectSnapshotVersion(project, new String[0]);
                LiferayThemeDefaultsPlugin.this._configureTaskUploadArchives(project, publishNodeModuleTask, (Task)updateVersionTask);
            }
        });
    }

    private Configuration _addConfigurationFrontendCSSCommon(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)FRONTEND_CSS_COMMON_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                LiferayThemeDefaultsPlugin.this._addDependenciesFrontendCSSCommon(project);
            }
        });
        configuration.setDescription("Configures com.liferay.frontend.css.common for compiling the theme.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesFrontendCSSCommon(Project project) {
        String version = PortalTools.getVersion((Project)project, (String)_FRONTEND_COMMON_CSS_NAME);
        GradleUtil.addDependency((Project)project, (String)FRONTEND_CSS_COMMON_CONFIGURATION_NAME, (String)"com.liferay", (String)_FRONTEND_COMMON_CSS_NAME, (String)version, (boolean)false);
    }

    private Copy _addTaskExpandFrontendCSSCommon(final Project project, final Configuration frontendCSSCommonConfguration) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)EXPAND_FRONTEND_CSS_COMMON_TASK_NAME, Copy.class);
        copy.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                project.delete(new Object[]{copy.getDestinationDir()});
            }
        });
        copy.eachFile((Action)new StripPathSegmentsAction(2));
        copy.from(new Object[]{new Closure<Void>((Object)project){

            public FileTree doCall() {
                return project.zipTree((Object)frontendCSSCommonConfguration.getSingleFile());
            }
        }});
        copy.include(new String[]{"META-INF/resources/"});
        copy.into((Object)new File(project.getBuildDir(), "frontend-css-common"));
        copy.setDescription("Expands com.liferay.frontend.css.common to a temporary directory.");
        copy.setIncludeEmptyDirs(false);
        return copy;
    }

    private Upload _addTaskInstall(Project project) {
        Upload upload = (Upload)GradleUtil.addTask((Project)project, (String)"install", Upload.class);
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        upload.setConfiguration(configuration);
        upload.setDescription("Installs the '" + configuration.getName() + "' artifacts into the local Maven repository.");
        return upload;
    }

    private PublishNodeModuleTask _addTaskPublishNodeModule(Task zipResourcesImporterArchivesTask) {
        PublishNodeModuleTask publishNodeModuleTask = (PublishNodeModuleTask)GradleUtil.addTask((Project)zipResourcesImporterArchivesTask.getProject(), (String)PUBLISH_NODE_MODULE_TASK_NAME, PublishNodeModuleTask.class);
        publishNodeModuleTask.dependsOn(new Object[]{zipResourcesImporterArchivesTask});
        publishNodeModuleTask.setDescription("Publishes this project to the NPM registry.");
        publishNodeModuleTask.setGroup("upload");
        return publishNodeModuleTask;
    }

    private Copy _addTaskRestoreMergeLangDestinationDir(final MergePropertiesTask mergePropertiesTask, final Copy saveMergeLangDestinationDirTask) {
        Copy copy = (Copy)GradleUtil.addTask((Project)mergePropertiesTask.getProject(), (String)RESTORE_MERGE_LANG_DESTINATION_DIR_TASK_NAME, Copy.class);
        copy.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                Project project = copy.getProject();
                project.delete(new Object[]{copy.getDestinationDir()});
            }
        });
        copy.from(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return saveMergeLangDestinationDirTask.getDestinationDir();
            }
        }});
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return mergePropertiesTask.getDestinationDir();
            }
        });
        copy.setDescription("Restore the destination directory of " + mergePropertiesTask + ".");
        return copy;
    }

    private Copy _addTaskSaveMergeLangDestinationDir(final MergePropertiesTask mergePropertiesTask) {
        Copy copy = (Copy)GradleUtil.addTask((Project)mergePropertiesTask.getProject(), (String)SAVE_MERGE_LANG_DESTINATION_DIR_TASK_NAME, Copy.class);
        copy.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                Project project = copy.getProject();
                project.delete(new Object[]{copy.getDestinationDir()});
            }
        });
        copy.from(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return mergePropertiesTask.getDestinationDir();
            }
        }});
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                Project project = mergePropertiesTask.getProject();
                return new File(project.getBuildDir(), "backup-" + mergePropertiesTask.getName());
            }
        });
        copy.setDescription("Saves the destination directory of " + mergePropertiesTask + " into a temporary location.");
        return copy;
    }

    private ReplaceRegexTask _addTaskUpdateVersion(Project project, WriteDigestTask writeParentThemesDigestTask) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)"updateVersion", ReplaceRegexTask.class);
        replaceRegexTask.finalizedBy(new Object[]{writeParentThemesDigestTask});
        for (String fileName : GradlePluginsDefaultsUtil.JSON_VERSION_FILE_NAMES) {
            File file = project.file((Object)fileName);
            if (!file.exists()) continue;
            replaceRegexTask.match(GradlePluginsDefaultsUtil.jsonVersionPattern.pattern(), file);
        }
        replaceRegexTask.setDescription("Updates the project version in the NPM files.");
        replaceRegexTask.setReplacement((Object)IncrementVersionClosure.MICRO_INCREMENT);
        return replaceRegexTask;
    }

    private WriteDigestTask _addTaskWriteParentThemesDigest(Project project, Project ... parentThemeProjects) {
        WriteDigestTask writeDigestTask = (WriteDigestTask)GradleUtil.addTask((Project)project, (String)WRITE_PARENT_THEMES_DIGEST_TASK_NAME, WriteDigestTask.class);
        writeDigestTask.setDescription("Writes a digest file to keep track of the parent themes used by this project.");
        for (Project parentThemeProject : parentThemeProjects) {
            if (parentThemeProject == null) continue;
            writeDigestTask.dependsOn(new Object[]{parentThemeProject.getPath() + ":" + "classes"});
            File dir = parentThemeProject.file((Object)"src/main/resources/META-INF/resources");
            writeDigestTask.source(new Object[]{dir});
        }
        return writeDigestTask;
    }

    private Task _addTaskZipDirectories(Project project, String taskName, File rootDir, File destinationDir, String extension) {
        Task task = project.task(taskName);
        StringBuilder sb = new StringBuilder();
        sb.append("Assembles ");
        sb.append(extension.toUpperCase());
        sb.append(" files in ");
        sb.append(project.relativePath((Object)destinationDir));
        sb.append(" from the subdirectories of ");
        sb.append(project.relativePath((Object)rootDir));
        sb.append('.');
        task.setDescription(sb.toString());
        File[] dirs = FileUtil.getDirectories(rootDir);
        if (dirs != null) {
            for (File dir : dirs) {
                Zip zip = this._addTaskZipDirectory(project, GradleUtil.getTaskName((String)taskName, (File)dir), dir, destinationDir, extension);
                task.dependsOn(new Object[]{zip});
            }
        }
        return task;
    }

    private Zip _addTaskZipDirectory(Project project, String taskName, File dir, File destinationDir, String extension) {
        Zip zip = (Zip)GradleUtil.addTask((Project)project, (String)taskName, Zip.class);
        zip.from(new Object[]{dir});
        zip.setArchiveName(dir.getName() + "." + extension);
        zip.setDestinationDir(destinationDir);
        zip.setDescription("Assembles " + project.relativePath((Object)zip.getArchivePath()) + " with the contents of the " + project.relativePath((Object)dir) + " directory.");
        return zip;
    }

    private void _applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/defaults/dependencies/config-maven.gradle", (Object)project);
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
    }

    private void _configureDeployDir(Project project) {
        final LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        boolean requiredForStartup = this._getPluginPackageProperty(project, "required-for-startup");
        if (requiredForStartup) {
            liferayExtension.setDeployDir((Object)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return new File(liferayExtension.getLiferayHome(), "osgi/war");
                }
            });
        } else {
            liferayExtension.setDeployDir((Object)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return new File(liferayExtension.getLiferayHome(), "deploy");
                }
            });
        }
    }

    private void _configureLangMerger(Project project) {
        final MergePropertiesTask mergePropertiesTask = (MergePropertiesTask)GradleUtil.getTask((Project)project, (String)"mergeLang");
        mergePropertiesTask.setDestinationDir((Object)"src/WEB-INF/src/content");
        Copy saveMergeLangDestinationDirTask = this._addTaskSaveMergeLangDestinationDir(mergePropertiesTask);
        mergePropertiesTask.dependsOn(new Object[]{saveMergeLangDestinationDirTask});
        final Copy restoreMergeLangDestinationDirTask = this._addTaskRestoreMergeLangDestinationDir(mergePropertiesTask, saveMergeLangDestinationDirTask);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteGulpTask.class, (Action)new Action<ExecuteGulpTask>(){

            public void execute(ExecuteGulpTask executeGulpTask) {
                executeGulpTask.dependsOn(new Object[]{mergePropertiesTask});
                executeGulpTask.finalizedBy(new Object[]{restoreMergeLangDestinationDirTask});
            }
        });
    }

    private void _configureProject(Project project) {
        String group = GradleUtil.getGradlePropertiesValue(project, "project.group", _GROUP);
        project.setGroup((Object)group);
    }

    private void _configureTaskExecuteGulp(ExecuteGulpTask executeGulpTask, Task zipResourcesImporterArchivesTask) {
        executeGulpTask.args(new Object[]{"--skip-update-check=true"});
        executeGulpTask.dependsOn(new Object[]{zipResourcesImporterArchivesTask});
    }

    private void _configureTaskExecuteGulpLocalDependencies(ExecuteGulpTask executeGulpTask, Copy expandFrontendCSSCommonTask, Project frontendThemeStyledProject, Project frontendThemeUnstyledProject) {
        File cssCommonDir = expandFrontendCSSCommonTask.getDestinationDir();
        executeGulpTask.args(new Object[]{"--css-common-path=" + FileUtil.getAbsolutePath((File)cssCommonDir)});
        executeGulpTask.dependsOn(new Object[]{expandFrontendCSSCommonTask});
        this._configureTaskExecuteGulpLocalDependenciesTheme(executeGulpTask, frontendThemeStyledProject, "styled");
        this._configureTaskExecuteGulpLocalDependenciesTheme(executeGulpTask, frontendThemeUnstyledProject, "unstyled");
    }

    private void _configureTaskExecuteGulpLocalDependenciesTheme(ExecuteGulpTask executeGulpTask, Project themeProject, String name) {
        if (themeProject == null) {
            Project project = executeGulpTask.getProject();
            Logger logger = project.getLogger();
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to configure {} parent theme", (Object)name);
            }
            return;
        }
        File dir = themeProject.file((Object)("src/main/resources/META-INF/resources/_" + name));
        executeGulpTask.args(new Object[]{"--" + name + "-path=" + FileUtil.getAbsolutePath((File)dir)});
        executeGulpTask.dependsOn(new Object[]{themeProject.getPath() + ":" + "classes"});
    }

    private void _configureTasksExecuteGulp(Project project, final Task zipResourcesImporterArchivesTask) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteGulpTask.class, (Action)new Action<ExecuteGulpTask>(){

            public void execute(ExecuteGulpTask executeGulpTask) {
                LiferayThemeDefaultsPlugin.this._configureTaskExecuteGulp(executeGulpTask, zipResourcesImporterArchivesTask);
            }
        });
    }

    private void _configureTasksExecuteGulpLocalDependencies(Project project, final Copy expandFrontendCSSCommonTask, final Project frontendThemeStyledProject, final Project frontendThemeUnstyledProject) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteGulpTask.class, (Action)new Action<ExecuteGulpTask>(){

            public void execute(ExecuteGulpTask executeGulpTask) {
                LiferayThemeDefaultsPlugin.this._configureTaskExecuteGulpLocalDependencies(executeGulpTask, expandFrontendCSSCommonTask, frontendThemeStyledProject, frontendThemeUnstyledProject);
            }
        });
    }

    private void _configureTaskUploadArchives(final Project project, PublishNodeModuleTask publishNodeModuleTask, Task updateVersionTask) {
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        if (FileUtil.exists((Project)project, (String)".lfrbuild-missing-resources-importer")) {
            Action<Task> action = new Action<Task>(){

                public void execute(Task task) {
                    throw new GradleException("Unable to publish " + project + ", resources-importer directory is missing");
                }
            };
            publishNodeModuleTask.doFirst((Action)action);
            uploadArchivesTask.doFirst((Action)action);
        }
        uploadArchivesTask.dependsOn(new Object[]{publishNodeModuleTask});
        if (!GradlePluginsDefaultsUtil.isSnapshot(project)) {
            uploadArchivesTask.finalizedBy(new Object[]{updateVersionTask});
        }
    }

    private boolean _getPluginPackageProperty(Project project, String key) {
        File file = project.file((Object)"src/WEB-INF/liferay-plugin-package.properties");
        if (!file.exists()) {
            return false;
        }
        Properties properties = GUtil.loadProperties((File)file);
        return Boolean.parseBoolean(properties.getProperty(key));
    }

    private Project _getThemeProject(Project project, String name) {
        Project parentProject = project.getParent();
        Project themeProject = parentProject.findProject(name);
        if (themeProject == null) {
            themeProject = GradleUtil.getProject(project.getRootProject(), name);
        }
        return themeProject;
    }
}

