/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.gradle.api.UncheckedIOException;

public class GitRepo {
    public final File dir;
    public final boolean readOnly;
    private static final String _GIT_REPO_FILE_NAME = ".gitrepo";

    public static GitRepo getGitRepo(File dir) {
        String content;
        if ((dir = GradleUtil.getRootDir(dir, _GIT_REPO_FILE_NAME)) == null) {
            return null;
        }
        try {
            File file = new File(dir, _GIT_REPO_FILE_NAME);
            content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
        boolean readOnly = false;
        if (content.contains("mode = pull")) {
            readOnly = true;
        }
        return new GitRepo(dir, readOnly);
    }

    private GitRepo(File dir, boolean readOnly) {
        this.dir = dir;
        this.readOnly = readOnly;
    }
}

