/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.defaults.internal.util.GitRepo;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.poshi.runner.PoshiRunnerResourcesPlugin;
import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class PoshiRunnerResourcesDefaultsPlugin
implements Plugin<Project> {
    private static final String _GROUP_ID = "com.liferay.poshi.runner.resources";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
        GradleUtil.applyPlugin((Project)project, PoshiRunnerResourcesPlugin.class);
        this._applyConfigScripts(project);
        this._configureTaskUploadPoshiRunnerResources(project);
    }

    private void _applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/defaults/dependencies/config-maven.gradle", (Object)project);
    }

    private void _configureTaskUploadPoshiRunnerResources(final Project project) {
        Upload upload = (Upload)GradleUtil.getTask((Project)project, (String)"uploadPoshiRunnerResources");
        upload.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                GitRepo gitRepo = GitRepo.getGitRepo(project.getProjectDir());
                return gitRepo == null || !gitRepo.readOnly;
            }
        });
        RepositoryHandler repositoryHandler = upload.getRepositories();
        final MavenDeployer mavenDeployer = (MavenDeployer)repositoryHandler.getAt("mavenDeployer");
        Configuration configuration = upload.getConfiguration();
        PublishArtifactSet publishArtifactSet = configuration.getAllArtifacts();
        publishArtifactSet.withType(ArchivePublishArtifact.class, (Action)new Action<ArchivePublishArtifact>(){

            public void execute(ArchivePublishArtifact archivePublishArtifact) {
                AbstractArchiveTask abstractArchiveTask = archivePublishArtifact.getArchiveTask();
                final String name = abstractArchiveTask.getArchiveName();
                mavenDeployer.addFilter(name, (Closure)new Closure<Boolean>((Object)project){

                    public Boolean doCall(Object artifact, File file) {
                        if (name.equals(file.getName())) {
                            return true;
                        }
                        return false;
                    }
                });
                MavenPom mavenPom = mavenDeployer.pom(name);
                mavenPom.setGroupId(PoshiRunnerResourcesDefaultsPlugin._GROUP_ID);
                mavenPom.setVersion(abstractArchiveTask.getVersion());
            }
        });
    }
}

