/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.testing.Test;

public class JaCoCoPlugin
implements Plugin<Project> {
    public static final Plugin<Project> INSTANCE = new JaCoCoPlugin();
    public static final String JACOCO_AGENT_CONFIGURATION_NAME = "jaCoCoAgent";

    public void apply(Project project) {
        Configuration jaCoCoAgentConfiguration = this._addConfigurationJaCoCoAgent(project);
        this._configureTasksTest(project, jaCoCoAgentConfiguration);
    }

    private JaCoCoPlugin() {
    }

    private Configuration _addConfigurationJaCoCoAgent(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)JACOCO_AGENT_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                JaCoCoPlugin.this._addDependenciesJaCoCoAgent(project);
            }
        });
        configuration.setDescription("Configures JaCoCo Agent to apply to the test tasks.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesJaCoCoAgent(Project project) {
        GradleUtil.addDependency((Project)project, (String)JACOCO_AGENT_CONFIGURATION_NAME, (String)"org.jacoco", (String)"org.jacoco.agent", (String)"0.7.9", (String)"runtime", (boolean)true);
    }

    private void _configureTasksTest(Project project, final Configuration jaCoCoAgentConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                JaCoCoPlugin.this._configureTaskTest(test, jaCoCoAgentConfiguration);
            }
        });
    }

    private void _configureTaskTest(Test test, final Configuration jaCoCoAgentConfiguration) {
        test.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Test test = (Test)task;
                Project project = test.getProject();
                String jaCoCoAgentFileName = FileUtil.getAbsolutePath((File)jaCoCoAgentConfiguration.getSingleFile());
                String jaCoCoDumpFileName = System.getProperty("jacoco.dump.file");
                if (Validator.isNull((String)jaCoCoDumpFileName)) {
                    File jaCoCoDumpFile = new File(project.getBuildDir(), "jacoco/" + test.getName() + ".exec");
                    jaCoCoDumpFileName = FileUtil.getAbsolutePath((File)jaCoCoDumpFile);
                }
                String jaCoCoJvmArg = "-javaagent:" + jaCoCoAgentFileName + "=destfile=" + jaCoCoDumpFileName + ",output=file,append=true";
                List allJVMArgs = test.getAllJvmArgs();
                for (int i = 0; i < allJVMArgs.size(); ++i) {
                    String jvmArg = (String)allJVMArgs.get(i);
                    if (!jvmArg.contains("-javaagent:")) continue;
                    jvmArg = jvmArg.replaceFirst("-javaagent:", jaCoCoJvmArg + " -javaagent:");
                    allJVMArgs.set(i, jvmArg);
                    test.setAllJvmArgs((Iterable)allJVMArgs);
                    return;
                }
                test.jvmArgs(new Object[]{jaCoCoJvmArg});
            }
        });
        test.systemProperty("jacoco.code.coverage", (Object)"true");
    }
}

