/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.tasks.WriteFindBugsProjectTask;
import com.liferay.gradle.plugins.jasper.jspc.CompileJSPTask;
import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.compile.JavaCompile;

public class FindSecurityBugsPlugin
implements Plugin<Project> {
    public static final String FIND_SECURITY_BUGS_CONFIGURATION_NAME = "findSecurityBugs";
    public static final String FIND_SECURITY_BUGS_PLUGINS_CONFIGURATION_NAME = "findSecurityBugsPlugins";
    public static final String FIND_SECURITY_BUGS_TASK_NAME = "findSecurityBugs";
    public static final Plugin<Project> INSTANCE = new FindSecurityBugsPlugin();
    public static final String WRITE_FIND_BUGS_PROJECT_TASK_NAME = "writeFindBugsProject";
    private static final String _FIND_SECURITY_BUGS_EXCLUDE_FILE_NAME = "fsb-exclude.xml";
    private static final String _FIND_SECURITY_BUGS_INCLUDE_FILE_NAME = "fsb-include.xml";
    private static final String _UNZIP_JAR_TASK_NAME = "unzipJar";
    private static final String _VERSION = "1.6.0.LIFERAY-PATCHED-3";

    public void apply(Project project) {
        Configuration findSecurityBugsConfiguration = this._addConfigurationFindSecurityBugs(project);
        Configuration findSecurityBugsPluginsConfiguration = this._addConfigurationFindSecurityBugsPlugins(project);
        WriteFindBugsProjectTask writeFindBugsProjectTask = this._addTaskWriteFindBugsProject(project);
        JavaExec findSecurityBugsTask = this._addTaskFindSecurityBugs(writeFindBugsProjectTask, (FileCollection)findSecurityBugsConfiguration, (FileCollection)findSecurityBugsPluginsConfiguration);
        this._checkTaskCheck((Task)findSecurityBugsTask);
    }

    private FindSecurityBugsPlugin() {
    }

    private Configuration _addConfigurationFindSecurityBugs(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)"findSecurityBugs");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                FindSecurityBugsPlugin.this._addDependenciesFindSecurityBugs(project);
            }
        });
        configuration.setDescription("Configures FindBugs for the 'findSecurityBugs' task.");
        configuration.setVisible(false);
        return configuration;
    }

    private Configuration _addConfigurationFindSecurityBugsPlugins(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)FIND_SECURITY_BUGS_PLUGINS_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                FindSecurityBugsPlugin.this._addDependenciesFindSecurityBugsPlugins(project);
            }
        });
        configuration.setDescription("Configures FindSecurityBugs.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesFindSecurityBugs(Project project) {
        GradleUtil.addDependency((Project)project, (String)"findSecurityBugs", (String)"com.google.code.findbugs", (String)"findbugs", (String)"3.0.1");
    }

    private void _addDependenciesFindSecurityBugsPlugins(Project project) {
        GradleUtil.addDependency((Project)project, (String)FIND_SECURITY_BUGS_PLUGINS_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.h3xstream.findsecbugs", (String)_VERSION);
    }

    private JavaExec _addTaskFindSecurityBugs(final WriteFindBugsProjectTask writeFindBugsProjectTask, FileCollection classpath, FileCollection pluginClasspath) {
        File falsePositivesTxtFile;
        File includeDir;
        Project project = writeFindBugsProjectTask.getProject();
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)project, (String)"findSecurityBugs", JavaExec.class);
        javaExec.args(new Object[]{"-bugCategories", "SECURITY", "-effort:max", "-html", "-medium", "-progress", "-timestampNow"});
        File excludeDir = GradleUtil.getRootDir(project, _FIND_SECURITY_BUGS_EXCLUDE_FILE_NAME);
        if (excludeDir != null) {
            File excludeFile = new File(excludeDir, _FIND_SECURITY_BUGS_EXCLUDE_FILE_NAME);
            javaExec.args(new Object[]{"-exclude", FileUtil.getAbsolutePath((File)excludeFile)});
        }
        if ((includeDir = GradleUtil.getRootDir(project, _FIND_SECURITY_BUGS_INCLUDE_FILE_NAME)) != null) {
            File includeFile = new File(includeDir, _FIND_SECURITY_BUGS_INCLUDE_FILE_NAME);
            javaExec.args(new Object[]{"-include", FileUtil.getAbsolutePath((File)includeFile)});
        }
        javaExec.args(new Object[]{"-project", new Object(){

            public String toString() {
                return FileUtil.getAbsolutePath((File)writeFindBugsProjectTask.getOutputFile());
            }
        }});
        Transformer<File, Task> outputFileGetter = new Transformer<File, Task>(){

            public File transform(Task task) {
                ReportingExtension reportingExtension = (ReportingExtension)GradleUtil.getExtension((ExtensionAware)task.getProject(), ReportingExtension.class);
                return new File(reportingExtension.getBaseDir(), task.getName() + "/reports.html");
            }
        };
        javaExec.doFirst((Action)new Action<Task>((Transformer)outputFileGetter, pluginClasspath){
            final /* synthetic */ Transformer val$outputFileGetter;
            final /* synthetic */ FileCollection val$pluginClasspath;
            {
                this.val$outputFileGetter = transformer;
                this.val$pluginClasspath = fileCollection;
            }

            public void execute(Task task) {
                JavaExec javaExec = (JavaExec)task;
                Logger logger = javaExec.getLogger();
                File outputFile = (File)this.val$outputFileGetter.transform((Object)javaExec);
                File outputDir = outputFile.getParentFile();
                outputDir.mkdirs();
                javaExec.args(new Object[]{"-outputFile", FileUtil.getAbsolutePath((File)outputFile)});
                javaExec.args(new Object[]{"-pluginList", this.val$pluginClasspath.getAsPath()});
                if (logger.isLifecycleEnabled()) {
                    logger.lifecycle("Using Find Security Bugs version 1.6.0.LIFERAY-PATCHED-3");
                }
            }
        });
        javaExec.doLast((Action)new Action<Task>((Transformer)outputFileGetter){
            final /* synthetic */ Transformer val$outputFileGetter;
            {
                this.val$outputFileGetter = transformer;
            }

            public void execute(Task task) {
                Logger logger = task.getLogger();
                File outputFile = (File)this.val$outputFileGetter.transform((Object)task);
                if (logger.isLifecycleEnabled()) {
                    logger.lifecycle("Find Security Bugs report saved to {}.", new Object[]{outputFile.getAbsolutePath()});
                }
            }
        });
        javaExec.dependsOn(new Object[]{writeFindBugsProjectTask});
        javaExec.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                FileCollection fileCollection = writeFindBugsProjectTask.getClasspath();
                if (fileCollection == null) {
                    return true;
                }
                Set files = fileCollection.getFiles();
                return this._containsClassOrJar(files.toArray(new File[files.size()]));
            }

            private boolean _containsClassOrJar(File[] files) {
                for (File file : files) {
                    String fileName;
                    if (!file.exists() || !(file.isFile() ? (fileName = file.getName()).endsWith(".class") || fileName.endsWith(".jar") : this._containsClassOrJar(file.listFiles()))) continue;
                    return true;
                }
                return false;
            }
        });
        javaExec.setClasspath(classpath);
        javaExec.setDescription("Runs FindSecurityBugs on this project.");
        javaExec.setGroup("verification");
        javaExec.setMain("edu.umd.cs.findbugs.FindBugs2");
        javaExec.systemProperty("findsecbugs.injection.customconfigfile.SqlInjectionDetector", (Object)"liferay-config/liferay-SqlInjectionDetector.txt|SQL_INJECTION_HIBERNATE");
        javaExec.systemProperty("findsecbugs.injection.customconfigfile.XssJspDetector", (Object)"liferay-config/liferay-XssJspDetector.txt|XSS_JSP_PRINT");
        javaExec.systemProperty("findsecbugs.taint.outputsummaries", (Object)"true");
        String customConfigFile = "liferay-config/liferay.txt";
        File derivedSummariesTxtFile = project.file((Object)"derived-summaries.txt");
        if (derivedSummariesTxtFile.exists()) {
            customConfigFile = customConfigFile + File.pathSeparator + FileUtil.getAbsolutePath((File)derivedSummariesTxtFile);
        }
        if ((falsePositivesTxtFile = project.file((Object)"find-security-bugs-false-positives.txt")).exists()) {
            customConfigFile = customConfigFile + File.pathSeparator + FileUtil.getAbsolutePath((File)falsePositivesTxtFile);
        }
        javaExec.systemProperty("findsecbugs.taint.customconfigfile", (Object)customConfigFile);
        return javaExec;
    }

    private WriteFindBugsProjectTask _addTaskWriteFindBugsProject(final Project project) {
        WriteFindBugsProjectTask writeFindBugsProjectTask = (WriteFindBugsProjectTask)GradleUtil.addTask((Project)project, (String)WRITE_FIND_BUGS_PROJECT_TASK_NAME, WriteFindBugsProjectTask.class);
        JavaCompile compileJSPTask = (JavaCompile)GradleUtil.getTask((Project)project, (String)"compileJSP");
        writeFindBugsProjectTask.dependsOn(new Object[]{_UNZIP_JAR_TASK_NAME, compileJSPTask});
        final SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        ConfigurableFileCollection auxClasspath = project.files(new Object[]{sourceSet.getCompileClasspath(), compileJSPTask.getClasspath()});
        writeFindBugsProjectTask.setAuxClasspath((FileCollection)auxClasspath);
        ConfigurableFileCollection classpath = project.files(new Object[]{compileJSPTask.getDestinationDir(), new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return sourceSetOutput.getClassesDir();
            }
        }});
        writeFindBugsProjectTask.setClasspath((FileCollection)classpath);
        writeFindBugsProjectTask.setDescription("Writes the FindBugs project file.");
        writeFindBugsProjectTask.setOutputFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), "findbugs.xml");
            }
        });
        writeFindBugsProjectTask.setProjectName(project.getName());
        CompileJSPTask generateJSPJavaTask = (CompileJSPTask)GradleUtil.getTask((Project)project, (String)"generateJSPJava");
        SourceDirectorySet sourceDirectorySet = sourceSet.getJava();
        ConfigurableFileCollection srcDirs = project.files(new Object[]{sourceDirectorySet.getSrcDirs(), generateJSPJavaTask.getDestinationDir()});
        writeFindBugsProjectTask.setSrcDirs((FileCollection)srcDirs);
        return writeFindBugsProjectTask;
    }

    private void _checkTaskCheck(Task findSecurityBugsTask) {
        Task task = GradleUtil.getTask((Project)findSecurityBugsTask.getProject(), (String)"check");
        task.dependsOn(new Object[]{findSecurityBugsTask});
    }
}

