/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.tasks;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import groovy.lang.Closure;
import groovy.util.AntBuilder;
import groovy.util.CharsetToolkit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;

public class InstallCacheTask
extends DefaultTask {
    private Object _artifactGroup;
    private Object _artifactName;
    private Object _artifactVersion;
    private Object _cacheRootDir;
    private Object _mavenRootDir;

    public InstallCacheTask() {
        Project project = this.getProject();
        Gradle gradle = project.getGradle();
        this._cacheRootDir = new File(gradle.getGradleUserHomeDir(), "caches/modules-2/files-2.1");
        this._mavenRootDir = new File(System.getProperty("user.home"), ".m2/repository");
    }

    @Input
    public String getArtifactGroup() {
        return GradleUtil.toString((Object)this._artifactGroup);
    }

    @Input
    public String getArtifactName() {
        return GradleUtil.toString((Object)this._artifactName);
    }

    @Input
    public String getArtifactVersion() {
        return GradleUtil.toString((Object)this._artifactVersion);
    }

    @OutputDirectory
    public File getCacheDestinationDir() {
        return new File(this.getCacheRootDir(), this.getArtifactGroup() + "/" + this.getArtifactName() + "/" + this.getArtifactVersion());
    }

    @Input
    public File getCacheRootDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._cacheRootDir);
    }

    @InputDirectory
    public File getMavenInputDir() {
        String artifactGroup = this.getArtifactGroup();
        return new File(this.getMavenRootDir(), artifactGroup.replace('.', '/') + "/" + this.getArtifactName() + "/" + this.getArtifactVersion());
    }

    @Input
    public File getMavenRootDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._mavenRootDir);
    }

    @TaskAction
    public void installCache() throws IOException {
        this._installCache("jar");
        this._installCache("pom");
    }

    public void setArtifactGroup(Object artifactGroup) {
        this._artifactGroup = artifactGroup;
    }

    public void setArtifactName(Object artifactName) {
        this._artifactName = artifactName;
    }

    public void setArtifactVersion(Object artifactVersion) {
        this._artifactVersion = artifactVersion;
    }

    public void setCacheRootDir(Object cacheRootDir) {
        this._cacheRootDir = cacheRootDir;
    }

    public void setMavenRootDir(Object mavenRootDir) {
        this._mavenRootDir = mavenRootDir;
    }

    private void _copy(final File file, final File destinationDir) {
        Project project = this.getProject();
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from(new Object[]{file});
                copySpec.into((Object)destinationDir);
            }
        });
    }

    private void _installCache(String extension) throws IOException {
        File file = new File(this.getMavenInputDir(), this.getArtifactName() + "-" + this.getArtifactVersion() + "." + extension);
        if (!file.exists()) {
            throw new GradleException("Unable to find " + file);
        }
        if (extension.equals("pom")) {
            file = this._normalizeTextFile(file);
        }
        HashValue hashValue = HashUtil.sha1((File)file);
        String hash = hashValue.asHexString();
        hash = hash.replaceFirst("^0*", "");
        this._copy(file, new File(this.getCacheDestinationDir(), hash));
    }

    private File _normalizeTextFile(File file) throws IOException {
        Project project = this.getProject();
        final File tempFile = new File(this.getTemporaryDir(), file.getName());
        this._copy(file, tempFile.getParentFile());
        CharsetToolkit charsetToolkit = new CharsetToolkit(tempFile);
        final Charset charset = charsetToolkit.getCharset();
        project.ant((Closure)new Closure<Void>((Object)project){

            public void doCall(AntBuilder antBuilder) {
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("encoding", charset.name());
                args.put("eol", "lf");
                args.put("file", tempFile);
                args.put("fixlast", false);
                args.put("outputencoding", StandardCharsets.UTF_8);
                antBuilder.invokeMethod("fixcrlf", args);
            }
        });
        return tempFile;
    }
}

