/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.plugins.whip.WhipExtension;
import com.liferay.gradle.plugins.whip.WhipPlugin;
import com.liferay.gradle.plugins.whip.WhipTaskExtension;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.testing.Test;

public class WhipDefaultsPlugin
extends BasePortalToolDefaultsPlugin<WhipPlugin> {
    public static final Plugin<Project> INSTANCE = new WhipDefaultsPlugin();
    private static final String _PORTAL_TOOL_NAME = "com.liferay.whip";

    protected void addPortalToolDependencies(Project project) {
        WhipExtension whipExtension = (WhipExtension)GradleUtil.getExtension((ExtensionAware)project, WhipExtension.class);
        String version = PortalTools.getVersion((Project)project, (String)this.getPortalToolName());
        if (Validator.isNotNull((String)version)) {
            whipExtension.setVersion(version);
        }
    }

    protected void configureDefaults(Project project, WhipPlugin whipPlugin) {
        super.configureDefaults(project, (Plugin)whipPlugin);
        this._configureTasksTest(project);
    }

    protected Class<WhipPlugin> getPluginClass() {
        return WhipPlugin.class;
    }

    protected String getPortalToolConfigurationName() {
        return "whip";
    }

    protected String getPortalToolName() {
        return _PORTAL_TOOL_NAME;
    }

    private WhipDefaultsPlugin() {
    }

    private void _configureTasksTest(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                WhipDefaultsPlugin.this._configureTaskTest(test);
            }
        });
    }

    private void _configureTaskTest(Test test) {
        WhipTaskExtension whipTaskExtension = (WhipTaskExtension)GradleUtil.getExtension((ExtensionAware)test, WhipTaskExtension.class);
        whipTaskExtension.excludes(new Object[]{".*Test", ".*Test\\$.*", ".*\\$Proxy.*", "com/liferay/whip/.*"});
        whipTaskExtension.includes(new Object[]{"com/liferay/.*"});
    }
}

