/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.tasks;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GUtil;

public class MergeFilesTask
extends DefaultTask {
    private final Set<Object> _inputFiles = new LinkedHashSet<Object>();
    private Object _outputFile;
    private Object _separator = System.lineSeparator();

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getInputFiles() {
        Project project = this.getProject();
        return project.files(new Object[]{this._inputFiles});
    }

    @OutputFile
    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    @Input
    public String getSeparator() {
        return GradleUtil.toString((Object)this._separator);
    }

    public MergeFilesTask inputFiles(Iterable<?> inputFiles) {
        GUtil.addToCollection(this._inputFiles, (Iterable[])new Iterable[]{inputFiles});
        return this;
    }

    public MergeFilesTask inputFiles(Object ... inputFiles) {
        return this.inputFiles(Arrays.asList(inputFiles));
    }

    @TaskAction
    public void mergeFiles() throws IOException {
        File outputFile = this.getOutputFile();
        String separator = this.getSeparator();
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(outputFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            boolean first = true;
            for (File inputFile : this.getInputFiles()) {
                if (!first) {
                    bufferedWriter.write(separator);
                }
                first = false;
                String content = new String(Files.readAllBytes(inputFile.toPath()), StandardCharsets.UTF_8);
                bufferedWriter.write(content);
            }
        }
    }

    public void setInputFiles(Iterable<?> inputFiles) {
        this._inputFiles.clear();
        this.inputFiles(inputFiles);
    }

    public void setInputFiles(Object ... inputFiles) {
        this.setInputFiles(Arrays.asList(inputFiles));
    }

    public void setOutputFile(Object outputFile) {
        this._outputFile = outputFile;
    }

    public void setSeparator(Object separator) {
        this._separator = separator;
    }
}

