/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.app.javadoc.builder.AppJavadocBuilderExtension;
import com.liferay.gradle.plugins.app.javadoc.builder.AppJavadocBuilderPlugin;
import com.liferay.gradle.plugins.defaults.LiferayOSGiDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.LiferayRelengPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.tasks.WritePropertiesTask;
import com.liferay.gradle.plugins.tlddoc.builder.AppTLDDocBuilderExtension;
import com.liferay.gradle.plugins.tlddoc.builder.AppTLDDocBuilderPlugin;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.gradle.StartParameter;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.util.GUtil;

public class LiferayAppDefaultsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        Gradle gradle;
        StartParameter startParameter;
        List taskNames;
        File appBndFile;
        String appDescription = GradleUtil.getProperty((ExtensionAware)project, (String)"app.description", (String)null);
        String appTitle = GradleUtil.getProperty((ExtensionAware)project, (String)"app.title", (String)null);
        String appVersion = GradleUtil.getProperty((ExtensionAware)project, (String)"app.version", (String)null);
        if (Validator.isNull((String)appDescription) && (appBndFile = project.file((Object)"app.bnd")).exists()) {
            Properties properties = GUtil.loadProperties((File)appBndFile);
            appDescription = properties.getProperty("Liferay-Releng-App-Description");
        }
        Properties appProperties = null;
        Project privateProject = project.findProject(":private" + project.getPath());
        if (privateProject != null) {
            appProperties = this._getAppProperties(privateProject);
        }
        if (appProperties == null) {
            appProperties = this._getAppProperties(project);
        }
        if (appProperties != null) {
            if (Validator.isNull((String)appTitle)) {
                appTitle = appProperties.getProperty("app.marketplace.title");
            }
            if (Validator.isNull((String)appVersion)) {
                appVersion = appProperties.getProperty("app.marketplace.version");
            }
        }
        this._applyPlugins(project);
        LiferayOSGiDefaultsPlugin.configureRepositories(project);
        this._configureAppJavadocBuilder(project, privateProject);
        this._configureAppTLDDocBuilder(project, privateProject);
        this._configureProject(project, appDescription, appVersion);
        this._configureTaskAppJavadoc(project, appTitle, appVersion);
        if (privateProject != null && ((taskNames = (startParameter = (gradle = project.getGradle()).getStartParameter()).getTaskNames()).contains("appJavadoc") || taskNames.contains("jarAppJavadoc") || taskNames.contains("appTLDDoc") || taskNames.contains("jarAppTLDDoc"))) {
            this._forceProjectHierarchyEvaluation(privateProject);
        }
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, AppJavadocBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, AppTLDDocBuilderPlugin.class);
    }

    private void _configureAppJavadocBuilder(Project project, Project privateProject) {
        AppJavadocBuilderExtension appJavadocBuilderExtension = (AppJavadocBuilderExtension)GradleUtil.getExtension((ExtensionAware)project, AppJavadocBuilderExtension.class);
        appJavadocBuilderExtension.onlyIf((Spec)new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                File artifactPropertiesFile;
                TaskContainer taskContainer = project.getTasks();
                WritePropertiesTask recordArtifactTask = (WritePropertiesTask)((Object)taskContainer.findByName("recordArtifact"));
                return recordArtifactTask != null && (artifactPropertiesFile = recordArtifactTask.getOutputFile()).exists();
            }
        });
        appJavadocBuilderExtension.setGroupNameClosure((Closure)new Closure<String>((Object)project){

            public String doCall(Project subproject) {
                return LiferayAppDefaultsPlugin.this._getAppJavadocGroupName(subproject);
            }
        });
        if (privateProject != null) {
            appJavadocBuilderExtension.subprojects((Iterable)privateProject.getSubprojects());
        }
    }

    private void _configureAppTLDDocBuilder(Project project, Project privateProject) {
        if (privateProject == null) {
            return;
        }
        AppTLDDocBuilderExtension appTLDDocBuilderExtension = (AppTLDDocBuilderExtension)GradleUtil.getExtension((ExtensionAware)project, AppTLDDocBuilderExtension.class);
        appTLDDocBuilderExtension.subprojects((Iterable)privateProject.getSubprojects());
    }

    private void _configureProject(Project project, String description, String version) {
        if (Validator.isNotNull((String)description)) {
            project.setDescription(description);
        }
        if (Validator.isNotNull((String)version)) {
            project.setVersion((Object)version);
        }
    }

    private void _configureTaskAppJavadoc(Project project, String appTitle, String appVersion) {
        File stylesheetFile;
        Javadoc javadoc = (Javadoc)GradleUtil.getTask((Project)project, (String)"appJavadoc");
        File portalRootDir = GradleUtil.getRootDir(project.getRootProject(), "portal-impl");
        if (portalRootDir != null && (stylesheetFile = new File(portalRootDir, "tools/styles/javadoc.css")).exists()) {
            StandardJavadocDocletOptions standardJavadocDocletOptions = (StandardJavadocDocletOptions)javadoc.getOptions();
            standardJavadocDocletOptions.setStylesheetFile(stylesheetFile);
        }
        if (Validator.isNotNull((String)appTitle) && Validator.isNotNull((String)appVersion)) {
            String title = String.format("%s %s API", appTitle, appVersion);
            javadoc.setTitle(title);
        }
    }

    private void _forceProjectHierarchyEvaluation(Project project) {
        GradleInternal gradleInternal = (GradleInternal)project.getGradle();
        ServiceRegistry serviceRegistry = gradleInternal.getServices();
        ProjectConfigurer projectConfigurer = (ProjectConfigurer)serviceRegistry.get(ProjectConfigurer.class);
        projectConfigurer.configureHierarchy((ProjectInternal)project);
    }

    private String _getAppJavadocGroupName(Project project) {
        TaskContainer taskContainer;
        WritePropertiesTask recordArtifactTask;
        String groupName = project.getDescription();
        if (Validator.isNull((String)groupName)) {
            groupName = project.getName();
        }
        if ((recordArtifactTask = (WritePropertiesTask)((Object)(taskContainer = project.getTasks()).findByName("recordArtifact"))) != null) {
            String artifactURL = null;
            File artifactPropertiesFile = recordArtifactTask.getOutputFile();
            if (artifactPropertiesFile.exists()) {
                Properties properties = GUtil.loadProperties((File)artifactPropertiesFile);
                artifactURL = properties.getProperty("artifact.url");
            }
            if (Validator.isNotNull(artifactURL)) {
                int start = artifactURL.lastIndexOf(47) + 1;
                int end = artifactURL.lastIndexOf(46);
                int pos = artifactURL.indexOf(45, start);
                String moduleName = artifactURL.substring(start, pos);
                String moduleVersion = artifactURL.substring(pos + 1, end);
                StringBuilder sb = new StringBuilder();
                sb.append(groupName);
                sb.append(" - com.liferay:");
                sb.append(moduleName);
                sb.append(':');
                sb.append(moduleVersion);
                groupName = sb.toString();
            }
        }
        return groupName;
    }

    private Properties _getAppProperties(Project project) {
        File appPropertiesFile;
        File relengDir = LiferayRelengPlugin.getRelengDir(project);
        if (relengDir != null && (appPropertiesFile = new File(relengDir, "app.properties")).exists()) {
            return GUtil.loadProperties((File)appPropertiesFile);
        }
        return null;
    }
}

