/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;

public class GradleUtil
extends com.liferay.gradle.util.GradleUtil {
    public static final String PORTAL_TOOL_GROUP = "com.liferay";
    public static final String SNAPSHOT_PROPERTY_NAME = "snapshot";
    public static final String SNAPSHOT_VERSION_SUFFIX = "-SNAPSHOT";

    public static <T extends Task> T addTask(Project project, String name, Class<T> clazz, boolean overwrite) {
        HashMap<String, Constable> args = new HashMap<String, Constable>();
        args.put("overwrite", Boolean.valueOf(overwrite));
        args.put("type", clazz);
        return (T)project.task(args, name);
    }

    public static void excludeTasksWithProperty(Project project, String propertyName, boolean defaultValue, String ... taskNames) {
        if (!project.hasProperty(propertyName) || !GradleUtil.getProperty((ExtensionAware)project, (String)propertyName, (boolean)defaultValue)) {
            return;
        }
        for (String taskName : taskNames) {
            Task task = GradleUtil.getTask((Project)project, (String)taskName);
            task.setDependsOn(Collections.emptySet());
            task.setEnabled(false);
            task.setFinalizedBy(Collections.emptySet());
        }
    }

    public static String getArchivesBaseName(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        return basePluginConvention.getArchivesBaseName();
    }

    public static Project getProject(Project rootProject, String name) {
        for (Project project : rootProject.getAllprojects()) {
            if (!name.equals(project.getName())) continue;
            return project;
        }
        return null;
    }

    public static Object getProperty(Object object, String name) {
        try {
            Class<?> clazz = object.getClass();
            Method hasPropertyMethod = clazz.getMethod("hasProperty", String.class);
            boolean hasProperty = (Boolean)hasPropertyMethod.invoke(object, name);
            if (!hasProperty) {
                return null;
            }
            Method getPropertyMethod = clazz.getMethod("getProperty", String.class);
            Object value = getPropertyMethod.invoke(object, name);
            if (value instanceof String && Validator.isNull((String)((String)value))) {
                value = null;
            }
            return value;
        }
        catch (ReflectiveOperationException roe) {
            throw new GradleException("Unable to get property", (Throwable)roe);
        }
    }

    public static String getProperty(Object object, String name, String defaultValue) {
        Object value = GradleUtil.getProperty(object, name);
        if (value == null) {
            return defaultValue;
        }
        return GradleUtil.toString((Object)value);
    }

    public static File getRootDir(File dir, String markerFileName) {
        do {
            File markerFile;
            if (!(markerFile = new File(dir, markerFileName)).exists()) continue;
            return dir;
        } while ((dir = dir.getParentFile()) != null);
        return null;
    }

    public static File getRootDir(Project project, String markerFileName) {
        return GradleUtil.getRootDir(project.getProjectDir(), markerFileName);
    }

    public static File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    public static boolean hasPlugin(Project project, Class<? extends Plugin<?>> pluginClass) {
        PluginContainer pluginContainer = project.getPlugins();
        return pluginContainer.hasPlugin(pluginClass);
    }

    public static boolean hasStartParameterTask(Project project, String taskName) {
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        List taskNames = startParameter.getTaskNames();
        return taskNames.contains(taskName);
    }

    public static boolean isFromMavenLocal(Project project, File file) {
        RepositoryHandler repositoryHandler = project.getRepositories();
        ArtifactRepository artifactRepository = (ArtifactRepository)repositoryHandler.findByName("MavenLocal");
        if (!(artifactRepository instanceof MavenArtifactRepository)) {
            return false;
        }
        MavenArtifactRepository mavenArtifactRepository = (MavenArtifactRepository)artifactRepository;
        Path repositoryPath = Paths.get(mavenArtifactRepository.getUrl());
        return FileUtil.isChild((File)file, (File)repositoryPath.toFile());
    }

    public static boolean isSnapshot(Project project) {
        String version = String.valueOf(project.getVersion());
        return version.endsWith(SNAPSHOT_VERSION_SUFFIX);
    }

    public static boolean isTestProject(Project project) {
        String projectName = project.getName();
        return projectName.endsWith("-test");
    }

    public static void setProjectSnapshotVersion(Project project, String ... propertyNames) {
        boolean snapshot = false;
        if (project.hasProperty(SNAPSHOT_PROPERTY_NAME)) {
            snapshot = GradleUtil.getProperty((ExtensionAware)project, (String)SNAPSHOT_PROPERTY_NAME, (boolean)true);
        }
        if (!snapshot) {
            for (String propertyName : propertyNames) {
                if (!project.hasProperty(propertyName) || !GradleUtil.getProperty((ExtensionAware)project, (String)propertyName, (boolean)true)) continue;
                snapshot = true;
                break;
            }
        }
        String version = String.valueOf(project.getVersion());
        if (snapshot && !version.endsWith(SNAPSHOT_VERSION_SUFFIX)) {
            project.setVersion((Object)(version + SNAPSHOT_VERSION_SUFFIX));
        }
    }

    public static <P extends Plugin<? extends Project>> void withPlugin(Project project, Class<P> pluginClass, Action<P> action) {
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(pluginClass, action);
    }
}

