/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.tasks;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GUtil;

public class ReplaceRegexTask
extends DefaultTask {
    private final Map<String, FileCollection> _matches = new LinkedHashMap<String, FileCollection>();
    private final List<Closure<String>> _preClosures = new ArrayList<Closure<String>>();
    private Object _replacement;
    private final List<Closure<Boolean>> _replaceOnlyIfClosures = new ArrayList<Closure<Boolean>>();

    @Input
    @SkipWhenEmpty
    public Map<String, FileCollection> getMatches() {
        return this._matches;
    }

    public List<Closure<String>> getPre() {
        return this._preClosures;
    }

    @Input
    public Object getReplacement() {
        return this._replacement;
    }

    public List<Closure<Boolean>> getReplaceOnlyIf() {
        return this._replaceOnlyIfClosures;
    }

    public ReplaceRegexTask match(String regex, Iterable<Object> files) {
        Project project = this.getProject();
        Object fileCollection = this._matches.get(regex);
        ConfigurableFileCollection filesFileCollection = project.files(new Object[]{files});
        fileCollection = fileCollection == null ? filesFileCollection : fileCollection.plus((FileCollection)filesFileCollection);
        this._matches.put(regex, (FileCollection)fileCollection);
        return this;
    }

    public ReplaceRegexTask match(String regex, Object ... files) {
        return this.match(regex, Arrays.asList(files));
    }

    public ReplaceRegexTask pre(Closure<String> ... preClosures) {
        return this.pre(Arrays.asList(preClosures));
    }

    public ReplaceRegexTask pre(Iterable<Closure<String>> preClosures) {
        GUtil.addToCollection(this._preClosures, (Iterable[])new Iterable[]{preClosures});
        return this;
    }

    public ReplaceRegexTask replaceOnlyIf(Closure<Boolean> ... replaceOnlyIfClosures) {
        return this.replaceOnlyIf(Arrays.asList(replaceOnlyIfClosures));
    }

    public ReplaceRegexTask replaceOnlyIf(Iterable<Closure<Boolean>> replaceOnlyIfClosures) {
        GUtil.addToCollection(this._replaceOnlyIfClosures, (Iterable[])new Iterable[]{replaceOnlyIfClosures});
        return this;
    }

    @TaskAction
    public void replaceRegex() throws IOException {
        Map<String, FileCollection> matches = this.getMatches();
        for (Map.Entry<String, FileCollection> entry : matches.entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey());
            FileCollection fileCollection = entry.getValue();
            for (File file : fileCollection) {
                this._replaceRegex(file, pattern);
            }
        }
    }

    public void setMatches(Map<String, FileCollection> matches) {
        this._matches.clear();
        this._matches.putAll(matches);
    }

    public void setPre(Closure<String> ... preClosures) {
        this.setPre(Arrays.asList(preClosures));
    }

    public void setPre(Iterable<Closure<String>> preClosures) {
        this._preClosures.clear();
        this.pre(preClosures);
    }

    public void setReplacement(Object replacement) {
        this._replacement = replacement;
    }

    public void setReplaceOnlyIf(Closure<Boolean> ... replaceOnlyIfClosures) {
        this.setReplaceOnlyIf(Arrays.asList(replaceOnlyIfClosures));
    }

    public void setReplaceOnlyIf(Iterable<Closure<Boolean>> replaceOnlyIfClosures) {
        this._replaceOnlyIfClosures.clear();
        this.replaceOnlyIf(replaceOnlyIfClosures);
    }

    private void _replaceRegex(File file, Pattern pattern) throws IOException {
        String content;
        Logger logger = this.getLogger();
        Path path = file.toPath();
        String newContent = content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        for (Closure<String> closure : this.getPre()) {
            newContent = (String)closure.call(new Object[]{newContent, file});
        }
        Matcher matcher = pattern.matcher(newContent);
        while (matcher.find()) {
            String replacement;
            boolean replace = true;
            int groupCount = matcher.groupCount();
            String group = matcher.group(groupCount);
            Object replacementObj = this.getReplacement();
            if (replacementObj instanceof Closure) {
                Closure replacementClosure = (Closure)replacementObj;
                replacement = (String)replacementClosure.call((Object)group);
            } else {
                replacement = GradleUtil.toString((Object)replacementObj);
            }
            for (Closure<Boolean> closure : this.getReplaceOnlyIf()) {
                if (((Boolean)closure.call(new Object[]{group, replacement, newContent, file})).booleanValue()) continue;
                replace = false;
                break;
            }
            if (replace) {
                newContent = newContent.substring(0, matcher.start(groupCount)) + replacement + newContent.substring(matcher.end(groupCount));
                continue;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info("Skipped replacement of {} to {} in {}", new Object[]{group, replacement, file});
        }
        if (!content.equals(newContent)) {
            Files.write(path, newContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            if (logger.isLifecycleEnabled()) {
                Project project = this.getProject();
                logger.lifecycle("Updated {}", new Object[]{project.relativePath((Object)file)});
            }
        }
    }
}

