/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.cache.CacheExtension;
import com.liferay.gradle.plugins.cache.CachePlugin;
import com.liferay.gradle.plugins.cache.WriteDigestTask;
import com.liferay.gradle.plugins.cache.task.TaskCache;
import com.liferay.gradle.plugins.change.log.builder.BuildChangeLogTask;
import com.liferay.gradle.plugins.change.log.builder.ChangeLogBuilderPlugin;
import com.liferay.gradle.plugins.defaults.LiferayOSGiDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.LiferayThemeDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GitUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.tasks.PrintArtifactPublishCommandsTask;
import com.liferay.gradle.plugins.defaults.tasks.ReplaceRegexTask;
import com.liferay.gradle.plugins.defaults.tasks.WritePropertiesTask;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.Upload;
import org.gradle.util.GUtil;

public class LiferayRelengPlugin
implements Plugin<Project> {
    public static final Plugin<Project> INSTANCE = new LiferayRelengPlugin();
    public static final String PRINT_ARTIFACT_PUBLISH_COMMANDS = "printArtifactPublishCommands";
    public static final String PRINT_DEPENDENT_ARTIFACT_TASK_NAME = "printDependentArtifact";
    public static final String PRINT_STALE_ARTIFACT_TASK_NAME = "printStaleArtifact";
    public static final String RECORD_ARTIFACT_TASK_NAME = "recordArtifact";
    public static final String UPDATE_VERSION_TASK_NAME = "updateVersion";

    public static File getRelengDir(Project project) {
        File rootDir = GradleUtil.getRootDir(project, ".releng");
        if (rootDir == null) {
            return null;
        }
        File relengDir = new File(rootDir, ".releng");
        return new File(relengDir, FileUtil.relativize((File)project.getProjectDir(), (File)rootDir));
    }

    public void apply(final Project project) {
        File relengDir = LiferayRelengPlugin.getRelengDir(project);
        if (relengDir == null) {
            return;
        }
        GradleUtil.applyPlugin((Project)project, ChangeLogBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
        final BuildChangeLogTask buildChangeLogTask = (BuildChangeLogTask)GradleUtil.getTask((Project)project, (String)"buildChangeLog");
        WritePropertiesTask recordArtifactTask = this._addTaskRecordArtifact(project, relengDir);
        this._addTaskPrintArtifactPublishCommands(project, recordArtifactTask);
        this._addTaskPrintStaleArtifact(project, recordArtifactTask);
        this._addTaskPrintDependentArtifact(project);
        this._configureTaskBuildChangeLog(buildChangeLogTask, relengDir);
        this._configureTaskUploadArchives(project, (Task)recordArtifactTask);
        GradleUtil.withPlugin(project, JavaPlugin.class, new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                LiferayRelengPlugin.this._configureTaskProcessResources(project, buildChangeLogTask);
            }
        });
    }

    private LiferayRelengPlugin() {
    }

    private PrintArtifactPublishCommandsTask _addTaskPrintArtifactPublishCommands(Project project, final WritePropertiesTask recordArtifactTask) {
        final PrintArtifactPublishCommandsTask printArtifactPublishCommandsTask = (PrintArtifactPublishCommandsTask)GradleUtil.addTask((Project)project, (String)PRINT_ARTIFACT_PUBLISH_COMMANDS, PrintArtifactPublishCommandsTask.class);
        printArtifactPublishCommandsTask.setArtifactPropertiesFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return recordArtifactTask.getOutputFile();
            }
        });
        printArtifactPublishCommandsTask.setDescription("Prints the artifact publish commands if this project has been changed since the last publish.");
        this._configureTaskEnabledIfStale((Task)printArtifactPublishCommandsTask, recordArtifactTask);
        String projectPath = project.getPath();
        if (projectPath.startsWith(":apps:") || projectPath.startsWith(":private:apps:")) {
            printArtifactPublishCommandsTask.onlyIf((Spec)new Spec<Task>(){

                public boolean isSatisfiedBy(Task task) {
                    return !LiferayRelengPlugin.this._hasProjectDependencies(task.getProject());
                }
            });
            this._configureTaskEnabledIfDependenciesArePublished((Task)printArtifactPublishCommandsTask);
        }
        GradleUtil.withPlugin(project, LiferayOSGiDefaultsPlugin.class, new Action<LiferayOSGiDefaultsPlugin>(){

            public void execute(LiferayOSGiDefaultsPlugin liferayOSGiDefaultsPlugin) {
                LiferayRelengPlugin.this._configureTaskPrintArtifactPublishCommandsForOSGi(printArtifactPublishCommandsTask);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                TaskContainer taskContainer = project.getTasks();
                Task task = (Task)taskContainer.findByName(LiferayRelengPlugin.UPDATE_VERSION_TASK_NAME);
                if (task instanceof ReplaceRegexTask) {
                    ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)task;
                    Map<String, FileCollection> matches = replaceRegexTask.getMatches();
                    printArtifactPublishCommandsTask.prepNextFiles(matches.values());
                }
                if (GradleUtil.hasPlugin(project, CachePlugin.class)) {
                    CacheExtension cacheExtension = (CacheExtension)GradleUtil.getExtension((ExtensionAware)project, CacheExtension.class);
                    for (TaskCache taskCache : cacheExtension.getTasks()) {
                        printArtifactPublishCommandsTask.prepNextFiles(new File(taskCache.getCacheDir(), ".digest"));
                    }
                }
                if (GradleUtil.hasPlugin(project, LiferayThemeDefaultsPlugin.class)) {
                    WriteDigestTask writeDigestTask = (WriteDigestTask)GradleUtil.getTask((Project)project, (String)"writeParentThemesDigest");
                    printArtifactPublishCommandsTask.prepNextCommitFile("digest", writeDigestTask.getDigestFile());
                }
            }
        });
        return printArtifactPublishCommandsTask;
    }

    private Task _addTaskPrintDependentArtifact(Project project) {
        Task task = project.task(PRINT_DEPENDENT_ARTIFACT_TASK_NAME);
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                File projectDir = project.getProjectDir();
                System.out.println(projectDir.getAbsolutePath());
            }
        });
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return LiferayRelengPlugin.this._hasProjectDependencies(task.getProject());
            }
        });
        task.setDescription("Prints the project directory if this project contains dependencies to other projects.");
        task.setGroup("verification");
        return task;
    }

    private Task _addTaskPrintStaleArtifact(Project project, WritePropertiesTask recordArtifactTask) {
        final Task task = project.task(PRINT_STALE_ARTIFACT_TASK_NAME);
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                File projectDir = project.getProjectDir();
                System.out.println(projectDir.getAbsolutePath());
            }
        });
        task.setDescription("Prints the project directory if this project has been changed since the last publish.");
        task.setGroup("verification");
        this._configureTaskEnabledIfStale(task, recordArtifactTask);
        GradleUtil.withPlugin(project, LiferayOSGiDefaultsPlugin.class, new Action<LiferayOSGiDefaultsPlugin>(){

            public void execute(LiferayOSGiDefaultsPlugin liferayOSGiDefaultsPlugin) {
                LiferayRelengPlugin.this._configureTaskPrintStaleArtifactForOSGi(task);
            }
        });
        return task;
    }

    private WritePropertiesTask _addTaskRecordArtifact(Project project, File destinationDir) {
        final WritePropertiesTask writePropertiesTask = (WritePropertiesTask)GradleUtil.addTask((Project)project, (String)RECORD_ARTIFACT_TASK_NAME, WritePropertiesTask.class);
        writePropertiesTask.property("artifact.git.id", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return GitUtil.getGitResult(writePropertiesTask.getProject(), "rev-parse", "HEAD");
            }
        });
        writePropertiesTask.setDescription("Records the commit ID and the artifact URLs.");
        writePropertiesTask.setOutputFile(new File(destinationDir, "artifact.properties"));
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        PublishArtifactSet publishArtifactSet = configuration.getArtifacts();
        Action<PublishArtifact> action = new Action<PublishArtifact>(){

            public void execute(final PublishArtifact publishArtifact) {
                writePropertiesTask.property(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        String key = publishArtifact.getClassifier();
                        key = Validator.isNull((String)key) ? "artifact.url" : "artifact." + key + ".url";
                        return key;
                    }
                }, (Object)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return LiferayRelengPlugin.this._getArtifactRemoteURL(writePropertiesTask.getProject(), publishArtifact, false);
                    }
                });
            }
        };
        publishArtifactSet.all((Action)action);
        return writePropertiesTask;
    }

    private void _configureTaskBuildChangeLog(BuildChangeLogTask buildChangeLogTask, File destinationDir) {
        buildChangeLogTask.setChangeLogFile((Object)new File(destinationDir, "liferay-releng.changelog"));
    }

    private void _configureTaskEnabledIfDependenciesArePublished(Task task) {
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                try {
                    Project project = task.getProject();
                    return !FileUtil.contains(project.getBuildFile(), "version: \"default\"");
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException((Throwable)ioe);
                }
            }
        });
    }

    private void _configureTaskEnabledIfRelease(Task task) {
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Project project = task.getProject();
                return GradleUtil.hasStartParameterTask(project, task.getName()) || !GradleUtil.isSnapshot(project);
            }
        });
    }

    private void _configureTaskEnabledIfStale(Task task, final WritePropertiesTask recordArtifactTask) {
        String force = GradleUtil.getTaskPrefixedProperty((Task)task, (String)"force");
        if (Boolean.parseBoolean(force)) {
            return;
        }
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return !FileUtil.exists((Project)task.getProject(), (String)".lfrbuild-releng-ignore");
            }
        });
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                File artifactPropertiesFile = recordArtifactTask.getOutputFile();
                Properties artifactProperties = artifactPropertiesFile.exists() ? GUtil.loadProperties((File)artifactPropertiesFile) : new Properties();
                return LiferayRelengPlugin.this._isStale(recordArtifactTask.getProject(), artifactProperties);
            }
        });
    }

    private void _configureTaskPrintArtifactPublishCommandsForOSGi(PrintArtifactPublishCommandsTask printArtifactPublishCommandsTask) {
        Project project = printArtifactPublishCommandsTask.getProject();
        if (GradleUtil.isTestProject(project)) {
            printArtifactPublishCommandsTask.setEnabled(false);
        }
        printArtifactPublishCommandsTask.setFirstPublishExcludedTaskName("updateFileVersions");
    }

    private void _configureTaskPrintStaleArtifactForOSGi(Task task) {
        if (GradleUtil.isTestProject(task.getProject())) {
            task.setEnabled(false);
        }
    }

    private void _configureTaskProcessResources(Project project, final BuildChangeLogTask buildChangeLogTask) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"processResources");
        copy.from((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildChangeLogTask.getChangeLogFile();
            }
        }, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.into((Object)"META-INF");
            }
        });
    }

    private void _configureTaskUploadArchives(Project project, Task recordArtifactTask) {
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        uploadArchivesTask.dependsOn(new Object[]{recordArtifactTask});
        this._configureTaskEnabledIfRelease(recordArtifactTask);
    }

    private StringBuilder _getArtifactRemoteBaseURL(Project project, boolean cdn) throws Exception {
        StringBuilder sb;
        Upload upload = (Upload)GradleUtil.getTask((Project)project, (String)"uploadArchives");
        RepositoryHandler repositoryHandler = upload.getRepositories();
        MavenDeployer mavenDeployer = (MavenDeployer)repositoryHandler.getAt("mavenDeployer");
        Object repository = mavenDeployer.getRepository();
        Class<?> repositoryClass = repository.getClass();
        Method getUrlMethod = repositoryClass.getMethod("getUrl", new Class[0]);
        String url = (String)getUrlMethod.invoke(repository, new Object[0]);
        if (cdn) {
            url = url.replace("http://", "http://cdn.");
            url = url.replace("https://", "https://cdn.");
        }
        if ((sb = new StringBuilder(url)).charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        String group = String.valueOf(project.getGroup());
        sb.append(group.replace('.', '/'));
        sb.append('/');
        return sb;
    }

    private String _getArtifactRemoteURL(Project project, PublishArtifact publishArtifact, boolean cdn) throws Exception {
        StringBuilder sb = this._getArtifactRemoteBaseURL(project, cdn);
        String name = GradleUtil.getArchivesBaseName(project);
        sb.append(name);
        sb.append('/');
        sb.append(project.getVersion());
        sb.append('/');
        sb.append(name);
        sb.append('-');
        sb.append(project.getVersion());
        String classifier = publishArtifact.getClassifier();
        if (Validator.isNotNull((String)classifier)) {
            sb.append('-');
            sb.append(classifier);
        }
        sb.append('.');
        sb.append(publishArtifact.getExtension());
        return sb.toString();
    }

    private boolean _hasProjectDependencies(Project project) {
        for (Configuration configuration : project.getConfigurations()) {
            for (Dependency dependency : configuration.getDependencies()) {
                if (!(dependency instanceof ProjectDependency)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _isStale(Project project, Properties artifactProperties) {
        String[] lines;
        Logger logger = project.getLogger();
        String artifactGitId = artifactProperties.getProperty("artifact.git.id");
        if (Validator.isNull((String)artifactGitId)) {
            if (logger.isInfoEnabled()) {
                logger.info("{} has never been published", (Object)project);
            }
            return true;
        }
        String result = GitUtil.getGitResult(project, "log", "--format=%s", artifactGitId + "..HEAD", ".");
        for (String line : lines = result.split("\\r?\\n")) {
            if (logger.isInfoEnabled()) {
                logger.info(line);
            }
            if (Validator.isNull((String)line) || line.contains("artifact:ignore")) continue;
            return true;
        }
        if (GradleUtil.hasPlugin(project, LiferayThemeDefaultsPlugin.class)) {
            WriteDigestTask writeDigestTask = (WriteDigestTask)GradleUtil.getTask((Project)project, (String)"writeParentThemesDigest");
            String digest = writeDigestTask.getDigest();
            String oldDigest = writeDigestTask.getOldDigest();
            if (logger.isInfoEnabled()) {
                logger.info("Digest for {} is {}, old digest is {}", new Object[]{writeDigestTask, digest, oldDigest});
            }
            if (!Objects.equals(digest, oldDigest)) {
                return true;
            }
        }
        return false;
    }
}

