/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.cache.WriteDigestTask;
import com.liferay.gradle.plugins.defaults.LiferayOSGiDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.internal.util.IncrementVersionClosure;
import com.liferay.gradle.plugins.defaults.tasks.ReplaceRegexTask;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.gulp.ExecuteGulpTask;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import groovy.lang.Closure;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.util.GUtil;

public class LiferayThemeDefaultsPlugin
implements Plugin<Project> {
    public static final String EXPAND_FRONTEND_CSS_COMMON_TASK_NAME = "expandFrontendCSSCommon";
    public static final String FRONTEND_CSS_COMMON_CONFIGURATION_NAME = "frontendCSSCommon";
    public static final String WRITE_PARENT_THEMES_DIGEST_TASK_NAME = "writeParentThemesDigest";
    public static final String ZIP_RESOURCES_IMPORTER_ARCHIVES_TASK_NAME = "zipResourcesImporterArchives";
    private static final String _FRONTEND_COMMON_CSS_NAME = "com.liferay.frontend.css.common";
    private static final String _GROUP = "com.liferay.plugins";
    private static final String _JSON_VERSION_REGEX = "\\n\\t\"version\": \"(.+)\"";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayThemePlugin.class);
        this._applyPlugins(project);
        this._addTaskInstall(project);
        this._applyConfigScripts(project);
        LiferayOSGiDefaultsPlugin.configureRepositories(project);
        Configuration frontendCSSCommonConfiguration = this._addConfigurationFrontendCSSCommon(project);
        Project frontendThemeStyledProject = this._getThemeProject(project, "frontend-theme-styled");
        Project frontendThemeUnstyledProject = this._getThemeProject(project, "frontend-theme-unstyled");
        WriteDigestTask writeDigestTask = this._addTaskWriteParentThemesDigest(project, frontendThemeStyledProject, frontendThemeUnstyledProject);
        Copy expandFrontendCSSCommonTask = this._addTaskExpandFrontendCSSCommon(project, frontendCSSCommonConfiguration);
        final ReplaceRegexTask updateVersionTask = this._addTaskUpdateVersion(project, writeDigestTask);
        File resourcesImporterArchivesDir = project.file((Object)"src/WEB-INF/src/resources-importer");
        File resourcesImporterExpandedArchivesDir = project.file((Object)"resources-importer");
        Task zipResourcesImporterArchivesTask = this._addTaskZipDirectories(project, ZIP_RESOURCES_IMPORTER_ARCHIVES_TASK_NAME, resourcesImporterExpandedArchivesDir, resourcesImporterArchivesDir, "lar");
        this._configureDeployDir(project);
        this._configureProject(project);
        this._configureTasksExecuteGulp(project, expandFrontendCSSCommonTask, zipResourcesImporterArchivesTask, frontendThemeStyledProject, frontendThemeUnstyledProject);
        GradleUtil.excludeTasksWithProperty(project, "snapshotIfStale", true, "install", "uploadArchives");
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                GradleUtil.setProjectSnapshotVersion(project, new String[0]);
                LiferayThemeDefaultsPlugin.this._configureTaskUploadArchives(project, (Task)updateVersionTask);
            }
        });
    }

    private Configuration _addConfigurationFrontendCSSCommon(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)FRONTEND_CSS_COMMON_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                LiferayThemeDefaultsPlugin.this._addDependenciesFrontendCSSCommon(project);
            }
        });
        configuration.setDescription("Configures com.liferay.frontend.css.common for compiling the theme.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesFrontendCSSCommon(Project project) {
        String version = PortalTools.getVersion((Project)project, (String)_FRONTEND_COMMON_CSS_NAME);
        GradleUtil.addDependency((Project)project, (String)FRONTEND_CSS_COMMON_CONFIGURATION_NAME, (String)"com.liferay", (String)_FRONTEND_COMMON_CSS_NAME, (String)version, (boolean)false);
    }

    private Copy _addTaskExpandFrontendCSSCommon(final Project project, final Configuration frontendCSSCommonConfguration) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)EXPAND_FRONTEND_CSS_COMMON_TASK_NAME, Copy.class);
        copy.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                project.delete(new Object[]{copy.getDestinationDir()});
            }
        });
        copy.eachFile((Action)new StripPathSegmentsAction(2));
        copy.from(new Object[]{new Closure<Void>((Object)project){

            public FileTree doCall() {
                return project.zipTree((Object)frontendCSSCommonConfguration.getSingleFile());
            }
        }});
        copy.include(new String[]{"META-INF/resources/"});
        copy.into((Object)new File(project.getBuildDir(), "frontend-css-common"));
        copy.setDescription("Expands com.liferay.frontend.css.common to a temporary directory.");
        copy.setIncludeEmptyDirs(false);
        return copy;
    }

    private Upload _addTaskInstall(Project project) {
        Upload upload = (Upload)GradleUtil.addTask((Project)project, (String)"install", Upload.class);
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        upload.setConfiguration(configuration);
        upload.setDescription("Installs the '" + configuration.getName() + "' artifacts into the local Maven repository.");
        return upload;
    }

    private ReplaceRegexTask _addTaskUpdateVersion(Project project, WriteDigestTask writeParentThemesDigestTask) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)"updateVersion", ReplaceRegexTask.class);
        replaceRegexTask.finalizedBy(new Object[]{writeParentThemesDigestTask});
        File npmShrinkwrapJsonFile = project.file((Object)"npm-shrinkwrap.json");
        if (npmShrinkwrapJsonFile.exists()) {
            replaceRegexTask.match(_JSON_VERSION_REGEX, npmShrinkwrapJsonFile);
        }
        replaceRegexTask.match(_JSON_VERSION_REGEX, "package.json");
        replaceRegexTask.setDescription("Updates the project version in the package.json file.");
        replaceRegexTask.setReplacement((Object)IncrementVersionClosure.MICRO_INCREMENT);
        return replaceRegexTask;
    }

    private WriteDigestTask _addTaskWriteParentThemesDigest(Project project, Project ... parentThemeProjects) {
        WriteDigestTask writeDigestTask = (WriteDigestTask)GradleUtil.addTask((Project)project, (String)WRITE_PARENT_THEMES_DIGEST_TASK_NAME, WriteDigestTask.class);
        writeDigestTask.setDescription("Writes a digest file to keep track of the parent themes used by this project.");
        for (Project parentThemeProject : parentThemeProjects) {
            if (parentThemeProject == null) continue;
            writeDigestTask.dependsOn(new Object[]{parentThemeProject.getPath() + ":" + "classes"});
            File dir = parentThemeProject.file((Object)"src/main/resources/META-INF/resources");
            writeDigestTask.source(new Object[]{dir});
        }
        return writeDigestTask;
    }

    private Task _addTaskZipDirectories(Project project, String taskName, File rootDir, File destinationDir, String extension) {
        Task task = project.task(taskName);
        StringBuilder sb = new StringBuilder();
        sb.append("Assembles ");
        sb.append(extension.toUpperCase());
        sb.append(" files in ");
        sb.append(project.relativePath((Object)destinationDir));
        sb.append(" from the subdirectories of ");
        sb.append(project.relativePath((Object)rootDir));
        sb.append('.');
        task.setDescription(sb.toString());
        File[] dirs = FileUtil.getDirectories(rootDir);
        if (dirs != null) {
            for (File dir : dirs) {
                Zip zip = this._addTaskZipDirectory(project, GradleUtil.getTaskName((String)taskName, (File)dir), dir, destinationDir, extension);
                task.dependsOn(new Object[]{zip});
            }
        }
        return task;
    }

    private Zip _addTaskZipDirectory(Project project, String taskName, File dir, File destinationDir, String extension) {
        Zip zip = (Zip)GradleUtil.addTask((Project)project, (String)taskName, Zip.class);
        zip.from(new Object[]{dir});
        zip.setArchiveName(dir.getName() + "." + extension);
        zip.setDestinationDir(destinationDir);
        zip.setDescription("Assembles " + project.relativePath((Object)zip.getArchivePath()) + " with the contents of the " + project.relativePath((Object)dir) + " directory.");
        return zip;
    }

    private void _applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/defaults/dependencies/config-maven.gradle", (Object)project);
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
    }

    private void _configureDeployDir(Project project) {
        final LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        boolean requiredForStartup = this._getPluginPackageProperty(project, "required-for-startup");
        if (requiredForStartup) {
            liferayExtension.setDeployDir((Object)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return new File(liferayExtension.getLiferayHome(), "osgi/war");
                }
            });
        } else {
            liferayExtension.setDeployDir((Object)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return new File(liferayExtension.getLiferayHome(), "deploy");
                }
            });
        }
    }

    private void _configureProject(Project project) {
        project.setGroup((Object)_GROUP);
    }

    private void _configureTaskExecuteGulp(ExecuteGulpTask executeGulpTask, final Copy expandFrontendCSSCommonTask, Task zipResourcesImporterLARsTask, Project frontendThemeStyledProject, Project frontendThemeUnstyledProject) {
        executeGulpTask.args(new Object[]{new Callable<String>(){

            @Override
            public String call() throws Exception {
                File dir = expandFrontendCSSCommonTask.getDestinationDir();
                return "--css-common-path=" + FileUtil.getAbsolutePath((File)dir);
            }
        }});
        executeGulpTask.dependsOn(new Object[]{expandFrontendCSSCommonTask, zipResourcesImporterLARsTask});
        this._configureTaskExecuteGulpParentTheme(executeGulpTask, frontendThemeStyledProject, "styled");
        this._configureTaskExecuteGulpParentTheme(executeGulpTask, frontendThemeUnstyledProject, "unstyled");
    }

    private void _configureTaskExecuteGulpParentTheme(ExecuteGulpTask executeGulpTask, Project themeProject, String name) {
        if (themeProject == null) {
            Project project = executeGulpTask.getProject();
            Logger logger = project.getLogger();
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to configure {} parent theme", (Object)name);
            }
            return;
        }
        File dir = themeProject.file((Object)("src/main/resources/META-INF/resources/_" + name));
        executeGulpTask.args(new Object[]{"--" + name + "-path=" + FileUtil.getAbsolutePath((File)dir)});
        executeGulpTask.dependsOn(new Object[]{themeProject.getPath() + ":" + "classes"});
    }

    private void _configureTasksExecuteGulp(Project project, final Copy expandFrontendCSSCommonTask, final Task assembleResourcesImporterArchivesTask, final Project frontendThemeStyledProject, final Project frontendThemeUnstyledProject) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteGulpTask.class, (Action)new Action<ExecuteGulpTask>(){

            public void execute(ExecuteGulpTask executeGulpTask) {
                LiferayThemeDefaultsPlugin.this._configureTaskExecuteGulp(executeGulpTask, expandFrontendCSSCommonTask, assembleResourcesImporterArchivesTask, frontendThemeStyledProject, frontendThemeUnstyledProject);
            }
        });
    }

    private void _configureTaskUploadArchives(final Project project, Task updateThemeVersionTask) {
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        if (FileUtil.exists((Project)project, (String)".lfrbuild-missing-resources-importer")) {
            uploadArchivesTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    throw new GradleException("Unable to publish " + project + ", resources-importer directory is missing");
                }
            });
        }
        if (!GradleUtil.isSnapshot(project)) {
            uploadArchivesTask.finalizedBy(new Object[]{updateThemeVersionTask});
        }
    }

    private boolean _getPluginPackageProperty(Project project, String key) {
        File file = project.file((Object)"src/WEB-INF/liferay-plugin-package.properties");
        if (!file.exists()) {
            return false;
        }
        Properties properties = GUtil.loadProperties((File)file);
        return Boolean.parseBoolean(properties.getProperty(key));
    }

    private Project _getThemeProject(Project project, String name) {
        Project parentProject = project.getParent();
        Project themeProject = parentProject.findProject(name);
        if (themeProject == null) {
            themeProject = GradleUtil.getProject(project.getRootProject(), name);
        }
        return themeProject;
    }
}

