/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.tasks;

import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

public class WritePropertiesTask
extends DefaultTask {
    private Object _outputFile;
    private final Map<String, Object> _properties = new TreeMap<String, Object>();

    @Input
    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    @Input
    @SkipWhenEmpty
    public Map<String, Object> getProperties() {
        return this._properties;
    }

    public WritePropertiesTask properties(Map<String, ?> properties) {
        this._properties.putAll(properties);
        return this;
    }

    public WritePropertiesTask property(String key, Object value) {
        this._properties.put(key, value);
        return this;
    }

    public void setOutputFile(Object outputFile) {
        this._outputFile = outputFile;
    }

    public void setProperties(Map<String, ?> properties) {
        this._properties.clear();
        this.properties(properties);
    }

    @TaskAction
    public void writeProperties() throws IOException {
        FileUtil.writeProperties(this.getOutputFile(), this.getProperties());
    }
}

