/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.task.WriteFindBugsProjectTask;
import com.liferay.gradle.plugins.jasper.jspc.CompileJSPTask;
import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Property;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

public class FindSecurityBugsPlugin
implements Plugin<Project> {
    public static final String FIND_SECURITY_BUGS_CONFIGURATION_NAME = "findSecurityBugs";
    public static final String FIND_SECURITY_BUGS_PLUGINS_CONFIGURATION_NAME = "findSecurityBugsPlugins";
    public static final String FIND_SECURITY_BUGS_TASK_NAME = "findSecurityBugs";
    public static final Plugin<Project> INSTANCE = new FindSecurityBugsPlugin();
    public static final String PRINT_FIND_SECURITY_BUGS_REPORT_TASK_NAME = "printFindSecurityBugsReport";
    public static final String WRITE_FIND_BUGS_PROJECT_TASK_NAME = "writeFindBugsProject";
    private static final String _FIND_SECURITY_BUGS_EXCLUDE_FILE_NAME = "fsb-exclude.xml";
    private static final String _FIND_SECURITY_BUGS_INCLUDE_FILE_NAME = "fsb-include.xml";
    private static final String _VERSION = "1.13.0.LIFERAY-PATCHED-1";
    private static final Transformer<File, Task> _reportsFileGetter = new Transformer<File, Task>(){

        public File transform(Task task) {
            ReportingExtension reportingExtension = (ReportingExtension)GradleUtil.getExtension((ExtensionAware)task.getProject(), ReportingExtension.class);
            return new File(reportingExtension.getBaseDir(), task.getName() + "/reports.html");
        }
    };

    public void apply(Project project) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration findSecurityBugsConfiguration = (Configuration)configurationContainer.create("findSecurityBugs");
        Configuration findSecurityBugsPluginsConfiguration = (Configuration)configurationContainer.create(FIND_SECURITY_BUGS_PLUGINS_CONFIGURATION_NAME);
        this._configureConfigurationFindSecurityBugs(project, findSecurityBugsConfiguration);
        this._configureConfigurationFindSecurityBugsPlugins(project, findSecurityBugsPluginsConfiguration);
        Convention convention = project.getConvention();
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)convention.getPlugin(JavaPluginConvention.class);
        TaskProvider findSecurityBugsTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)"findSecurityBugs", JavaExec.class);
        TaskProvider printFindSecurityBugsReportTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)PRINT_FIND_SECURITY_BUGS_REPORT_TASK_NAME, Task.class);
        TaskProvider writeFindBugsProjectTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)WRITE_FIND_BUGS_PROJECT_TASK_NAME, WriteFindBugsProjectTask.class);
        TaskProvider checkTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"check");
        TaskProvider classesTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"classes");
        TaskProvider compileJSPTaskProivder = GradleUtil.getTaskProvider((Project)project, (String)"compileJSP", JavaCompile.class);
        TaskProvider generateJSPJavaTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"generateJSPJava", CompileJSPTask.class);
        this._configureTaskCheckProvider((TaskProvider<Task>)checkTaskProvider, (TaskProvider<JavaExec>)findSecurityBugsTaskProvider);
        this._configureTaskFindSecurityBugsProvider(project, findSecurityBugsConfiguration, findSecurityBugsPluginsConfiguration, (TaskProvider<JavaExec>)findSecurityBugsTaskProvider, (TaskProvider<Task>)printFindSecurityBugsReportTaskProvider, (TaskProvider<WriteFindBugsProjectTask>)writeFindBugsProjectTaskProvider);
        this._configureTaskPrintFindSecurityBugsReportProvider((TaskProvider<JavaExec>)findSecurityBugsTaskProvider, (TaskProvider<Task>)printFindSecurityBugsReportTaskProvider);
        this._configureTaskWriteFindBugsProjectProvider(project, javaPluginConvention, (TaskProvider<Task>)classesTaskProvider, (TaskProvider<JavaCompile>)compileJSPTaskProivder, (TaskProvider<CompileJSPTask>)generateJSPJavaTaskProvider, (TaskProvider<WriteFindBugsProjectTask>)writeFindBugsProjectTaskProvider);
    }

    private FindSecurityBugsPlugin() {
    }

    private void _configureConfigurationFindSecurityBugs(final Project project, Configuration findSecurityBugsConfiguration) {
        findSecurityBugsConfiguration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                GradleUtil.addDependency((Project)project, (String)"findSecurityBugs", (String)"com.github.spotbugs", (String)"spotbugs", (String)"4.9.3");
            }
        });
        findSecurityBugsConfiguration.setDescription("Configures FindBugs for the 'findSecurityBugs' task.");
        findSecurityBugsConfiguration.setVisible(false);
    }

    private void _configureConfigurationFindSecurityBugsPlugins(final Project project, Configuration findSecurityBugsPluginsConfiguration) {
        findSecurityBugsPluginsConfiguration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                GradleUtil.addDependency((Project)project, (String)FindSecurityBugsPlugin.FIND_SECURITY_BUGS_PLUGINS_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.h3xstream.findsecbugs", (String)FindSecurityBugsPlugin._VERSION);
            }
        });
        findSecurityBugsPluginsConfiguration.setDescription("Configures FindSecurityBugs.");
        findSecurityBugsPluginsConfiguration.setVisible(false);
    }

    private void _configureTaskCheckProvider(TaskProvider<Task> checkTaskProvider, final TaskProvider<JavaExec> findSecurityBugsTaskProvider) {
        checkTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task checkTask) {
                checkTask.dependsOn(new Object[]{findSecurityBugsTaskProvider});
            }
        });
    }

    private void _configureTaskFindSecurityBugsProvider(final Project project, final Configuration findSecurityBugsConfiguration, final Configuration findSecurityBugsPluginsConfiguration, TaskProvider<JavaExec> findSecurityBugsTaskProvider, final TaskProvider<Task> printFindSecurityBugsReportTaskProvider, final TaskProvider<WriteFindBugsProjectTask> writeFindBugsProjectTaskProvider) {
        findSecurityBugsTaskProvider.configure((Action)new Action<JavaExec>(){

            public void execute(JavaExec findSecurityBugsJavaExec) {
                File includeDir;
                findSecurityBugsJavaExec.finalizedBy(new Object[]{printFindSecurityBugsReportTaskProvider});
                findSecurityBugsJavaExec.args(new Object[]{"-bugCategories", "SECURITY", "-effort:max", "-exitcode", "-html", "-medium", "-progress", "-timestampNow"});
                File excludeDir = GradleUtil.getRootDir((Project)project, (String)FindSecurityBugsPlugin._FIND_SECURITY_BUGS_EXCLUDE_FILE_NAME);
                if (excludeDir != null) {
                    File excludeFile = new File(excludeDir, FindSecurityBugsPlugin._FIND_SECURITY_BUGS_EXCLUDE_FILE_NAME);
                    findSecurityBugsJavaExec.args(new Object[]{"-exclude", FileUtil.getAbsolutePath((File)excludeFile)});
                }
                if ((includeDir = GradleUtil.getRootDir((Project)project, (String)FindSecurityBugsPlugin._FIND_SECURITY_BUGS_INCLUDE_FILE_NAME)) != null) {
                    File includeFile = new File(includeDir, FindSecurityBugsPlugin._FIND_SECURITY_BUGS_INCLUDE_FILE_NAME);
                    findSecurityBugsJavaExec.args(new Object[]{"-include", FileUtil.getAbsolutePath((File)includeFile)});
                }
                final WriteFindBugsProjectTask writeFindBugsProjectTask = (WriteFindBugsProjectTask)((Object)writeFindBugsProjectTaskProvider.get());
                findSecurityBugsJavaExec.args(new Object[]{"-project", new Object(){

                    public String toString() {
                        return FileUtil.getAbsolutePath((File)writeFindBugsProjectTask.getOutputFile());
                    }
                }});
                findSecurityBugsJavaExec.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        JavaExec javaExec = (JavaExec)task;
                        Logger logger = javaExec.getLogger();
                        File outputFile = (File)_reportsFileGetter.transform((Object)javaExec);
                        File outputDir = outputFile.getParentFile();
                        outputDir.mkdirs();
                        javaExec.args(new Object[]{"-outputFile", FileUtil.getAbsolutePath((File)outputFile)});
                        javaExec.args(new Object[]{"-pluginList", findSecurityBugsPluginsConfiguration.getAsPath()});
                        if (logger.isLifecycleEnabled()) {
                            logger.lifecycle("Using Find Security Bugs version 1.13.0.LIFERAY-PATCHED-1");
                        }
                    }
                });
                findSecurityBugsJavaExec.dependsOn(new Object[]{writeFindBugsProjectTask});
                findSecurityBugsJavaExec.onlyIf((Spec)new Spec<Task>(){

                    public boolean isSatisfiedBy(Task task) {
                        FileCollection fileCollection = writeFindBugsProjectTask.getClasspath();
                        if (fileCollection == null) {
                            return true;
                        }
                        Set files = fileCollection.getFiles();
                        return this._containsClassOrJar(files.toArray(new File[0]));
                    }

                    private boolean _containsClassOrJar(File[] files) {
                        for (File file : files) {
                            String fileName;
                            if (!file.exists() || !(file.isFile() ? (fileName = file.getName()).endsWith(".class") || fileName.endsWith(".jar") : this._containsClassOrJar(file.listFiles()))) continue;
                            return true;
                        }
                        return false;
                    }
                });
                Property mainClass = findSecurityBugsJavaExec.getMainClass();
                mainClass.set((Object)"edu.umd.cs.findbugs.FindBugs2");
                findSecurityBugsJavaExec.setClasspath((FileCollection)findSecurityBugsConfiguration);
                findSecurityBugsJavaExec.setDebug(Boolean.getBoolean("findSecurityBugs.debug"));
                findSecurityBugsJavaExec.setDescription("Runs FindSecurityBugs on this project.");
                findSecurityBugsJavaExec.setGroup("verification");
                findSecurityBugsJavaExec.setIgnoreExitValue(true);
                findSecurityBugsJavaExec.systemProperty("findsecbugs.injection.customconfigfile.PathTraversalDetector", (Object)"liferay-config/liferay-PathTraversalDetector-PATH_TRAVERSAL_IN.txt|PATH_TRAVERSAL_IN:liferay-config/liferay-PathTraversalDetector-PATH_TRAVERSAL_OUT.txt|PATH_TRAVERSAL_OUT");
                findSecurityBugsJavaExec.systemProperty("findsecbugs.injection.customconfigfile.SqlInjectionDetector", (Object)"liferay-config/liferay-SqlInjectionDetector.txt|SQL_INJECTION_HIBERNATE");
                findSecurityBugsJavaExec.systemProperty("findsecbugs.injection.customconfigfile.SSRFDetector", (Object)"liferay-config/liferay-SSRFDetector.txt|URLCONNECTION_SSRF_FD");
                findSecurityBugsJavaExec.systemProperty("findsecbugs.injection.customconfigfile.XssJspDetector", (Object)"liferay-config/liferay-XssJspDetector.txt|XSS_JSP_PRINT");
                findSecurityBugsJavaExec.systemProperty("findsecbugs.injection.customconfigfile.XssServletDetector", (Object)"liferay-config/liferay-XssServletDetector.txt|XSS_SERVLET");
                findSecurityBugsJavaExec.systemProperty("findsecbugs.taint.outputconfigs", (Object)"true");
                String customConfigFile = "liferay-config/liferay.txt";
                File directoryFile = project.file((Object)".");
                for (Path directoryPath = directoryFile.toPath(); directoryPath != null; directoryPath = directoryPath.getParent()) {
                    File falsePositivesTxtFile = new File(directoryPath.toFile(), "find-security-bugs-false-positives.txt");
                    if (!falsePositivesTxtFile.exists()) continue;
                    String absolutePath = FileUtil.getAbsolutePath((File)falsePositivesTxtFile);
                    customConfigFile = customConfigFile + File.pathSeparator + absolutePath;
                }
                findSecurityBugsJavaExec.systemProperty("findsecbugs.taint.customconfigfile", (Object)customConfigFile);
            }
        });
    }

    private void _configureTaskPrintFindSecurityBugsReportProvider(final TaskProvider<JavaExec> findSecurityBugsTaskProvider, TaskProvider<Task> printFindSecurityBugsReportTaskProvider) {
        printFindSecurityBugsReportTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task printFindSecurityBugsReportTask) {
                printFindSecurityBugsReportTask.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        Logger logger = task.getLogger();
                        if (logger.isLifecycleEnabled()) {
                            JavaExec findSecurityBugsJavaExec = (JavaExec)findSecurityBugsTaskProvider.get();
                            File outputFile = (File)_reportsFileGetter.transform((Object)findSecurityBugsJavaExec);
                            logger.lifecycle("Find Security Bugs report saved to {}", new Object[]{outputFile.getAbsolutePath()});
                        }
                    }
                });
                printFindSecurityBugsReportTask.setDescription("Prints the path of the Find Security Bugs report.");
            }
        });
    }

    private void _configureTaskWriteFindBugsProjectProvider(final Project project, final JavaPluginConvention javaPluginConvention, final TaskProvider<Task> classesTaskProvider, final TaskProvider<JavaCompile> compileJSPTaskProvider, final TaskProvider<CompileJSPTask> generateJSPJavaTaskProvider, TaskProvider<WriteFindBugsProjectTask> writeFindBugsProjectTaskProvider) {
        writeFindBugsProjectTaskProvider.configure((Action)new Action<WriteFindBugsProjectTask>(){

            public void execute(WriteFindBugsProjectTask writeFindBugsProjectTask) {
                writeFindBugsProjectTask.dependsOn(new Object[]{classesTaskProvider});
                writeFindBugsProjectTask.dependsOn(new Object[]{generateJSPJavaTaskProvider});
                writeFindBugsProjectTask.dependsOn(new Object[]{compileJSPTaskProvider});
                final SourceSet mainSourceSet = FindSecurityBugsPlugin.this._getSourceSet(javaPluginConvention, "main");
                SourceDirectorySet javaSourceDirectorySet = mainSourceSet.getJava();
                final JavaCompile compileJSPJavaCompile = (JavaCompile)compileJSPTaskProvider.get();
                writeFindBugsProjectTask.setAuxClasspath((FileCollection)project.files(new Object[]{mainSourceSet.getCompileClasspath(), compileJSPJavaCompile.getClasspath()}));
                writeFindBugsProjectTask.setClasspath((FileCollection)project.files(new Object[]{new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return compileJSPJavaCompile.getDestinationDir();
                    }
                }, new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return FileUtil.getJavaClassesDir((SourceSet)mainSourceSet);
                    }
                }}));
                writeFindBugsProjectTask.setDescription("Writes the FindBugs project file.");
                writeFindBugsProjectTask.setOutputFile(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return new File(project.getBuildDir(), "findbugs.xml");
                    }
                });
                writeFindBugsProjectTask.setProjectName(project.getName());
                CompileJSPTask generateJSPJavaCompileJSPTask = (CompileJSPTask)generateJSPJavaTaskProvider.get();
                writeFindBugsProjectTask.setSrcDirs((FileCollection)project.files(new Object[]{javaSourceDirectorySet.getSrcDirs(), generateJSPJavaCompileJSPTask.getDestinationDir()}));
            }
        });
    }

    private SourceSet _getSourceSet(JavaPluginConvention javaPluginConvention, String name) {
        SourceSetContainer sourceSetContainer = javaPluginConvention.getSourceSets();
        return (SourceSet)sourceSetContainer.getByName(name);
    }
}

