/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;

public class LiferaySettingsPlugin
implements Plugin<Settings> {
    public static final String PROJECT_PATH_PREFIX_PROPERTY_NAME = "project.path.prefix";

    public void apply(Settings settings) {
        File rootDir = settings.getRootDir();
        Path rootDirPath = rootDir.toPath();
        String projectPathPrefix = GradleUtil.getProperty(settings, PROJECT_PATH_PREFIX_PROPERTY_NAME, "");
        if (Validator.isNotNull((String)projectPathPrefix)) {
            if (projectPathPrefix.charAt(0) != ':') {
                projectPathPrefix = ":" + projectPathPrefix;
            }
            if (projectPathPrefix.charAt(projectPathPrefix.length() - 1) == ':') {
                projectPathPrefix = projectPathPrefix.substring(0, projectPathPrefix.length() - 1);
            }
        }
        try {
            this._includeProjects(settings, rootDirPath, rootDirPath, projectPathPrefix);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    protected Set<Path> getDirPaths(String key, Path rootDirPath) {
        String dirNamesString = System.getProperty(key);
        if (Validator.isNull((String)dirNamesString)) {
            return Collections.emptySet();
        }
        HashSet<Path> dirPaths = new HashSet<Path>();
        for (String dirName : dirNamesString.split(",")) {
            dirPaths.add(rootDirPath.resolve(dirName));
        }
        return dirPaths;
    }

    @Deprecated
    protected void includeProject(Settings settings, Path projectDirPath, Path projectPathRootDirPath) {
        this._includeProject(settings, projectDirPath, projectPathRootDirPath, "");
    }

    @Deprecated
    protected void includeProjects(Settings settings, Path rootDirPath, Path projectPathRootDirPath) throws IOException {
        this._includeProjects(settings, rootDirPath, projectPathRootDirPath, "");
    }

    private <T extends Enum<T>> Set<T> _getFlags(String prefix, Class<T> clazz) {
        EnumSet<T> flags = EnumSet.allOf(clazz);
        Iterator iterator = flags.iterator();
        while (iterator.hasNext()) {
            Enum flag = (Enum)iterator.next();
            String flagName = flag.toString();
            flagName = flagName.replace('_', '.');
            flagName = flagName.toLowerCase();
            if (Boolean.getBoolean(prefix + flagName)) continue;
            iterator.remove();
        }
        return flags;
    }

    private ProjectDirType _getProjectDirType(Path dirPath) {
        if (Files.exists(dirPath.resolve("build.xml"), new LinkOption[0])) {
            return ProjectDirType.ANT_PLUGIN;
        }
        if (Files.exists(dirPath.resolve("bnd.bnd"), new LinkOption[0])) {
            return ProjectDirType.MODULE;
        }
        if (Files.exists(dirPath.resolve("gulpfile.js"), new LinkOption[0])) {
            return ProjectDirType.THEME;
        }
        return ProjectDirType.UNKNOWN;
    }

    private void _includeProject(Settings settings, Path projectDirPath, Path projectPathRootDirPath, String projectPathPrefix) {
        Path relativePath = projectPathRootDirPath.relativize(projectDirPath);
        String projectPath = relativePath.toString();
        projectPath = projectPathPrefix + ":" + projectPath.replace(File.separatorChar, ':');
        settings.include(new String[]{projectPath});
        ProjectDescriptor projectDescriptor = settings.findProject(projectPath);
        projectDescriptor.setProjectDir(projectDirPath.toFile());
    }

    private void _includeProjects(final Settings settings, final Path rootDirPath, final Path projectPathRootDirPath, final String projectPathPrefix) throws IOException {
        final Set<Path> excludedDirPaths = this.getDirPaths("build.exclude.dirs", rootDirPath);
        final Set<ProjectDirType> excludedProjectDirTypes = this._getFlags("build.exclude.", ProjectDirType.class);
        final boolean portalBuild = Boolean.getBoolean("portal.build");
        final boolean portalPreBuild = Boolean.getBoolean("portal.pre.build");
        Files.walkFileTree(rootDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                if (dirPath.equals(rootDirPath)) {
                    return FileVisitResult.CONTINUE;
                }
                if (excludedDirPaths.contains(dirPath)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                ProjectDirType projectDirType = LiferaySettingsPlugin.this._getProjectDirType(dirPath);
                if (projectDirType == ProjectDirType.UNKNOWN) {
                    return FileVisitResult.CONTINUE;
                }
                if (excludedProjectDirTypes.contains((Object)projectDirType)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (portalBuild && Files.notExists(dirPath.resolve(".lfrbuild-portal"), new LinkOption[0])) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (portalPreBuild && Files.notExists(dirPath.resolve(".lfrbuild-portal-pre"), new LinkOption[0])) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                LiferaySettingsPlugin.this._includeProject(settings, dirPath, projectPathRootDirPath, projectPathPrefix);
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
    }

    private static enum ProjectDirType {
        ANT_PLUGIN,
        MODULE,
        THEME,
        UNKNOWN;

    }
}

