/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.cache.CachePlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.util.Validator;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;

public class LiferayCIPlugin
implements Plugin<Project> {
    private static final File _NODE_MODULES_CACHE_DIR = new File(System.getProperty("user.home"), ".liferay/node-modules-cache");
    private static final int _NPM_INSTALL_RETRIES = 3;

    public void apply(Project project) {
        this._configureTasksDownloadNode(project);
        this._configureTasksExecuteNode(project);
        this._configureTasksExecuteNpm(project);
        this._configureTasksNpmInstall(project);
    }

    private void _configureTaskDownloadNode(DownloadNodeTask downloadNodeTask) {
        downloadNodeTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                if (GradleUtil.hasPlugin(task.getProject(), CachePlugin.class)) {
                    throw new GradleException("Unable to use Node.js on CI, please configure com.liferay.cache or update the cache");
                }
            }
        });
    }

    private void _configureTaskExecuteNode(ExecuteNodeTask executeNodeTask) {
        executeNodeTask.setNpmInstallRetries(3);
    }

    private void _configureTaskExecuteNpm(ExecuteNpmTask executeNpmTask, String registry) {
        executeNpmTask.setRegistry((Object)registry);
    }

    private void _configureTaskNpmInstall(NpmInstallTask npmInstallTask) {
        npmInstallTask.setNodeModulesCacheDir((Object)_NODE_MODULES_CACHE_DIR);
        npmInstallTask.setRemoveShrinkwrappedUrls(true);
    }

    private void _configureTasksDownloadNode(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DownloadNodeTask.class, (Action)new Action<DownloadNodeTask>(){

            public void execute(DownloadNodeTask downloadNodeTask) {
                LiferayCIPlugin.this._configureTaskDownloadNode(downloadNodeTask);
            }
        });
    }

    private void _configureTasksExecuteNode(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNodeTask.class, (Action)new Action<ExecuteNodeTask>(){

            public void execute(ExecuteNodeTask executeNodeTask) {
                LiferayCIPlugin.this._configureTaskExecuteNode(executeNodeTask);
            }
        });
    }

    private void _configureTasksExecuteNpm(Project project) {
        final String ciRegistry = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.ci.registry", (String)null);
        if (Validator.isNull((String)ciRegistry)) {
            return;
        }
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNpmTask.class, (Action)new Action<ExecuteNpmTask>(){

            public void execute(ExecuteNpmTask executeNpmTask) {
                LiferayCIPlugin.this._configureTaskExecuteNpm(executeNpmTask, ciRegistry);
            }
        });
    }

    private void _configureTasksNpmInstall(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                LiferayCIPlugin.this._configureTaskNpmInstall(npmInstallTask);
            }
        });
    }
}

