/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;

public class LiferaySettingsPlugin
implements Plugin<Settings> {
    public static final String PROJECT_PATH_PREFIX_PROPERTY_NAME = "project.path.prefix";

    public void apply(Settings settings) {
        File rootDir = settings.getRootDir();
        Path rootDirPath = rootDir.toPath();
        String projectPathPrefix = GradleUtil.getProperty(settings, PROJECT_PATH_PREFIX_PROPERTY_NAME, "");
        if (Validator.isNotNull((String)projectPathPrefix)) {
            if (projectPathPrefix.charAt(0) != ':') {
                projectPathPrefix = ":" + projectPathPrefix;
            }
            if (projectPathPrefix.charAt(projectPathPrefix.length() - 1) == ':') {
                projectPathPrefix = projectPathPrefix.substring(0, projectPathPrefix.length() - 1);
            }
        }
        try {
            this._includeProjects(settings, rootDirPath, rootDirPath, projectPathPrefix);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    protected Set<Path> getDirPaths(String key, Path rootDirPath) {
        String dirNamesString = System.getProperty(key);
        if (Validator.isNull((String)dirNamesString)) {
            return Collections.emptySet();
        }
        HashSet<Path> dirPaths = new HashSet<Path>();
        for (String dirName : dirNamesString.split(",")) {
            dirPaths.add(rootDirPath.resolve(dirName));
        }
        return dirPaths;
    }

    @Deprecated
    protected void includeProject(Settings settings, Path projectDirPath, Path projectPathRootDirPath) {
        this._includeProject(settings, projectDirPath, projectPathRootDirPath, "");
    }

    @Deprecated
    protected void includeProjects(Settings settings, Path rootDirPath, Path projectPathRootDirPath) throws IOException {
        this._includeProjects(settings, rootDirPath, projectPathRootDirPath, "");
    }

    private void _includeProject(Settings settings, Path projectDirPath, Path projectPathRootDirPath, String projectPathPrefix) {
        Path relativePath = projectPathRootDirPath.relativize(projectDirPath);
        String projectPath = relativePath.toString();
        projectPath = projectPathPrefix + ":" + projectPath.replace(File.separatorChar, ':');
        settings.include(new String[]{projectPath});
        ProjectDescriptor projectDescriptor = settings.findProject(projectPath);
        projectDescriptor.setProjectDir(projectDirPath.toFile());
    }

    private void _includeProjects(final Settings settings, final Path rootDirPath, final Path projectPathRootDirPath, final String projectPathPrefix) throws IOException {
        final Set<Path> excludedDirPaths = this.getDirPaths("build.exclude.dirs", rootDirPath);
        final boolean modulesOnlyBuild = Boolean.getBoolean("modules.only.build");
        final boolean portalBuild = Boolean.getBoolean("portal.build");
        Files.walkFileTree(rootDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                if (dirPath.equals(rootDirPath)) {
                    return FileVisitResult.CONTINUE;
                }
                if (excludedDirPaths.contains(dirPath)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                boolean moduleProjectDir = false;
                boolean otherProjectDir = false;
                if (Files.exists(dirPath.resolve("bnd.bnd"), new LinkOption[0])) {
                    moduleProjectDir = true;
                } else if (Files.exists(dirPath.resolve("build.xml"), new LinkOption[0]) || Files.exists(dirPath.resolve("gulpfile.js"), new LinkOption[0])) {
                    otherProjectDir = true;
                }
                if (!moduleProjectDir && !otherProjectDir) {
                    return FileVisitResult.CONTINUE;
                }
                if (portalBuild && Files.notExists(dirPath.resolve(".lfrbuild-portal"), new LinkOption[0])) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (moduleProjectDir || !modulesOnlyBuild) {
                    LiferaySettingsPlugin.this._includeProject(settings, dirPath, projectPathRootDirPath, projectPathPrefix);
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
    }
}

