/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.util.ArrayUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashMap;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskInputs;

public class FileUtil
extends com.liferay.gradle.util.FileUtil {
    public static File[] getDirectories(File dir) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    public static FileTree getJarsFileTree(Project project, File dir, String ... excludes) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", dir);
        if (ArrayUtil.isNotEmpty((Object[])excludes)) {
            args.put("excludes", Arrays.asList(excludes));
        }
        args.put("include", "*.jar");
        return project.fileTree(args);
    }

    public static String getRelativePath(Project project, File file) {
        String relativePath = project.relativePath((Object)file);
        return relativePath.replace('\\', '/');
    }

    public static boolean hasSourceFiles(Task task, Spec<File> spec) {
        TaskInputs taskInputs = task.getInputs();
        FileCollection fileCollection = taskInputs.getSourceFiles();
        return !(fileCollection = fileCollection.filter(spec)).isEmpty();
    }

    public static FileCollection join(FileCollection ... fileCollections) {
        FileCollection joinedFileCollection = null;
        for (FileCollection fileCollection : fileCollections) {
            joinedFileCollection = joinedFileCollection == null ? fileCollection : joinedFileCollection.plus(fileCollection);
        }
        return joinedFileCollection;
    }
}

