/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.cache.WriteDigestTask;
import com.liferay.gradle.plugins.defaults.LiferayOSGiDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.internal.util.IncrementVersionClosure;
import com.liferay.gradle.plugins.defaults.tasks.ReplaceRegexTask;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.gulp.ExecuteGulpTask;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.Upload;

public class LiferayThemeDefaultsPlugin
implements Plugin<Project> {
    public static final String EXPAND_FRONTEND_CSS_COMMON_TASK_NAME = "expandFrontendCSSCommon";
    public static final String FRONTEND_CSS_COMMON_CONFIGURATION_NAME = "frontendCSSCommon";
    public static final String WRITE_PARENT_THEMES_DIGEST_TASK_NAME = "writeParentThemesDigest";
    private static final String _FRONTEND_COMMON_CSS_NAME = "com.liferay.frontend.css.common";
    private static final String _GROUP = "com.liferay.plugins";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayThemePlugin.class);
        this.applyPlugins(project);
        this.addTaskInstall(project);
        this.applyConfigScripts(project);
        LiferayOSGiDefaultsPlugin.configureRepositories(project);
        Configuration frontendCSSCommonConfiguration = this.addConfigurationFrontendCSSCommon(project);
        Project frontendThemeStyledProject = this.getThemeProject(project, "frontend-theme-styled");
        Project frontendThemeUnstyledProject = this.getThemeProject(project, "frontend-theme-unstyled");
        WriteDigestTask writeDigestTask = this.addTaskWriteParentThemesDigest(project, frontendThemeStyledProject, frontendThemeUnstyledProject);
        Copy expandFrontendCSSCommonTask = this.addTaskExpandFrontendCSSCommon(project, frontendCSSCommonConfiguration);
        final ReplaceRegexTask updateVersionTask = this.addTaskUpdateVersion(project, writeDigestTask);
        this.configureDeployDir(project);
        this.configureProject(project);
        this.configureTasksExecuteGulp(project, expandFrontendCSSCommonTask, frontendThemeStyledProject, frontendThemeUnstyledProject);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                GradleUtil.setProjectSnapshotVersion(project);
                LiferayThemeDefaultsPlugin.this.configureTaskUploadArchives(project, (Task)updateVersionTask);
            }
        });
    }

    protected Configuration addConfigurationFrontendCSSCommon(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)FRONTEND_CSS_COMMON_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                LiferayThemeDefaultsPlugin.this.addDependenciesFrontendCSSCommon(project);
            }
        });
        configuration.setDescription("Configures com.liferay.frontend.css.common for compiling the theme.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        return configuration;
    }

    protected void addDependenciesFrontendCSSCommon(Project project) {
        String version = PortalTools.getVersion((Project)project, (String)_FRONTEND_COMMON_CSS_NAME);
        GradleUtil.addDependency((Project)project, (String)FRONTEND_CSS_COMMON_CONFIGURATION_NAME, (String)"com.liferay", (String)_FRONTEND_COMMON_CSS_NAME, (String)version, (boolean)false);
    }

    protected Copy addTaskExpandFrontendCSSCommon(final Project project, final Configuration frontendCSSCommonConfguration) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)EXPAND_FRONTEND_CSS_COMMON_TASK_NAME, Copy.class);
        copy.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                project.delete(new Object[]{copy.getDestinationDir()});
            }
        });
        copy.eachFile((Action)new StripPathSegmentsAction(2));
        copy.from(new Object[]{new Closure<Void>((Object)project){

            public FileTree doCall() {
                return project.zipTree((Object)frontendCSSCommonConfguration.getSingleFile());
            }
        }});
        copy.include(new String[]{"META-INF/resources/"});
        copy.into((Object)new File(project.getBuildDir(), "frontend-css-common"));
        copy.setDescription("Expands com.liferay.frontend.css.common to a temporary directory.");
        copy.setIncludeEmptyDirs(false);
        return copy;
    }

    protected Upload addTaskInstall(Project project) {
        Upload upload = (Upload)GradleUtil.addTask((Project)project, (String)"install", Upload.class);
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        upload.setConfiguration(configuration);
        upload.setDescription("Installs the '" + configuration.getName() + "' artifacts into the local Maven repository.");
        return upload;
    }

    protected ReplaceRegexTask addTaskUpdateVersion(Project project, WriteDigestTask writeParentThemesDigestTask) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)"updateVersion", ReplaceRegexTask.class);
        replaceRegexTask.finalizedBy(new Object[]{writeParentThemesDigestTask});
        replaceRegexTask.match("\\n\\t\"version\": \"(.+)\"", "package.json");
        replaceRegexTask.setDescription("Updates the project version in the package.json file.");
        replaceRegexTask.setReplacement((Object)IncrementVersionClosure.MICRO_INCREMENT);
        return replaceRegexTask;
    }

    protected WriteDigestTask addTaskWriteParentThemesDigest(Project project, Project ... parentThemeProjects) {
        WriteDigestTask writeDigestTask = (WriteDigestTask)GradleUtil.addTask((Project)project, (String)WRITE_PARENT_THEMES_DIGEST_TASK_NAME, WriteDigestTask.class);
        writeDigestTask.setDescription("Writes a digest file to keep track of the parent themes used by this project.");
        for (Project parentThemeProject : parentThemeProjects) {
            if (parentThemeProject == null) continue;
            writeDigestTask.dependsOn(new Object[]{parentThemeProject.getPath() + ":" + "classes"});
            File dir = parentThemeProject.file((Object)"src/main/resources/META-INF/resources");
            writeDigestTask.source(new Object[]{dir});
        }
        return writeDigestTask;
    }

    protected void applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/defaults/dependencies/config-maven.gradle", (Object)project);
    }

    protected void applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
    }

    protected void configureDeployDir(Project project) {
        final LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        boolean requiredForStartup = this.getPluginPackageProperty(project, "required-for-startup");
        if (requiredForStartup) {
            liferayExtension.setDeployDir((Object)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return new File(liferayExtension.getLiferayHome(), "osgi/war");
                }
            });
        } else {
            liferayExtension.setDeployDir((Object)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return new File(liferayExtension.getLiferayHome(), "deploy");
                }
            });
        }
    }

    protected void configureProject(Project project) {
        project.setGroup((Object)_GROUP);
    }

    protected void configureTaskExecuteGulp(ExecuteGulpTask executeGulpTask, final Copy expandFrontendCSSCommonTask, Project frontendThemeStyledProject, Project frontendThemeUnstyledProject) {
        executeGulpTask.args(new Object[]{new Callable<String>(){

            @Override
            public String call() throws Exception {
                File dir = expandFrontendCSSCommonTask.getDestinationDir();
                return "--css-common-path=" + FileUtil.getAbsolutePath((File)dir);
            }
        }});
        executeGulpTask.dependsOn(new Object[]{expandFrontendCSSCommonTask});
        this.configureTaskExecuteGulpParentTheme(executeGulpTask, frontendThemeStyledProject, "styled");
        this.configureTaskExecuteGulpParentTheme(executeGulpTask, frontendThemeUnstyledProject, "unstyled");
    }

    protected void configureTaskExecuteGulpParentTheme(ExecuteGulpTask executeGulpTask, Project themeProject, String name) {
        if (themeProject == null) {
            Project project = executeGulpTask.getProject();
            Logger logger = project.getLogger();
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to configure {} parent theme", (Object)name);
            }
            return;
        }
        File dir = themeProject.file((Object)("src/main/resources/META-INF/resources/_" + name));
        executeGulpTask.args(new Object[]{"--" + name + "-path=" + FileUtil.getAbsolutePath((File)dir)});
        executeGulpTask.dependsOn(new Object[]{themeProject.getPath() + ":" + "classes"});
    }

    protected void configureTasksExecuteGulp(Project project, final Copy expandFrontendCSSCommonTask, final Project frontendThemeStyledProject, final Project frontendThemeUnstyledProject) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteGulpTask.class, (Action)new Action<ExecuteGulpTask>(){

            public void execute(ExecuteGulpTask executeGulpTask) {
                LiferayThemeDefaultsPlugin.this.configureTaskExecuteGulp(executeGulpTask, expandFrontendCSSCommonTask, frontendThemeStyledProject, frontendThemeUnstyledProject);
            }
        });
    }

    protected void configureTaskUploadArchives(Project project, Task updateThemeVersionTask) {
        if (GradleUtil.isSnapshot(project)) {
            return;
        }
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        uploadArchivesTask.finalizedBy(new Object[]{updateThemeVersionTask});
    }

    protected boolean getPluginPackageProperty(Project project, String key) {
        try {
            Properties properties = FileUtil.readProperties((Project)project, (String)"src/WEB-INF/liferay-plugin-package.properties");
            return Boolean.parseBoolean(properties.getProperty(key));
        }
        catch (IOException ioe) {
            throw new GradleException("Unable to read liferay-plugin-package.properties", (Throwable)ioe);
        }
    }

    protected Project getThemeProject(Project project, String name) {
        Project parentProject = project.getParent();
        Project themeProject = parentProject.findProject(name);
        if (themeProject == null) {
            themeProject = GradleUtil.getProject(project.getRootProject(), name);
        }
        return themeProject;
    }
}

