/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.LiferayAntPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.tasks.ReplaceRegexTask;
import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.tasks.Upload;

public class LiferayAntDefaultsPlugin
implements Plugin<Project> {
    private static final String _GROUP = "com.liferay.plugins";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayAntPlugin.class);
        this.applyPlugins(project);
        this.addTaskInstall(project);
        this.applyConfigScripts(project);
        final ReplaceRegexTask updateVersionTask = this.addTaskUpdateVersion(project);
        this.configureProject(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                GradleUtil.setProjectSnapshotVersion(project);
                LiferayAntDefaultsPlugin.this.configureTaskUploadArchives(project, (Task)updateVersionTask);
            }
        });
    }

    protected Upload addTaskInstall(Project project) {
        Upload upload = GradleUtil.addTask(project, "install", Upload.class, true);
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        upload.setConfiguration(configuration);
        upload.setDescription("Installs the '" + configuration.getName() + "' artifacts into the local Maven repository.");
        return upload;
    }

    protected ReplaceRegexTask addTaskUpdateVersion(Project project) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)"updateVersion", ReplaceRegexTask.class);
        replaceRegexTask.match("module-incremental-version=(\\d+)", "docroot/WEB-INF/liferay-plugin-package.properties");
        replaceRegexTask.setDescription("Updates \"module-incremental-version\" in the liferay-plugin-package.properties file.");
        replaceRegexTask.setReplacement(new Closure<String>((Object)project){

            public String doCall(String group) {
                int moduleIncrementalVersion = Integer.parseInt(group);
                return String.valueOf(moduleIncrementalVersion + 1);
            }
        });
        return replaceRegexTask;
    }

    protected void applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/defaults/dependencies/config-maven.gradle", (Object)project);
    }

    protected void applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
    }

    protected void configureProject(Project project) {
        project.setGroup((Object)_GROUP);
    }

    protected void configureTaskUploadArchives(Project project, Task updatePluginVersionTask) {
        if (GradleUtil.isSnapshot(project)) {
            return;
        }
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        uploadArchivesTask.finalizedBy(new Object[]{updatePluginVersionTask});
    }
}

