/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.db.support.task;

import com.liferay.gradle.plugins.db.support.internal.util.GradleUtil;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public abstract class BaseDBSupportTask
extends JavaExec {
    private Object _password;
    private Object _propertiesFile;
    private Object _url;
    private Object _userName;

    public BaseDBSupportTask() {
        Property mainClass = this.getMainClass();
        mainClass.set((Object)"com.liferay.portal.tools.db.support.DBSupport");
    }

    public void exec() {
        this.setArgs(this.getCompleteArgs());
        super.exec();
    }

    @Input
    public abstract String getCommand();

    @Input
    @Optional
    public String getPassword() {
        return GradleUtil.toString((Object)this._password);
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getPropertiesFile() {
        return GradleUtil.toFile(this.getProject(), this._propertiesFile);
    }

    @Input
    @Optional
    public String getUrl() {
        return GradleUtil.toString((Object)this._url);
    }

    @Input
    @Optional
    public String getUserName() {
        return GradleUtil.toString((Object)this._userName);
    }

    public void setPassword(Object password) {
        this._password = password;
    }

    public void setPropertiesFile(Object propertiesFile) {
        this._propertiesFile = propertiesFile;
    }

    public void setUrl(Object url) {
        this._url = url;
    }

    public void setUserName(Object userName) {
        this._userName = userName;
    }

    @Internal
    protected List<String> getCompleteArgs() {
        String userName;
        String url;
        File propertiesFile;
        ArrayList<String> completeArgs = new ArrayList<String>();
        GUtil.addToCollection(completeArgs, (Iterable)this.getArgs());
        String password = this.getPassword();
        if (Validator.isNotNull((String)password)) {
            completeArgs.add("--password");
            completeArgs.add(password);
        }
        if ((propertiesFile = this.getPropertiesFile()) != null && propertiesFile.exists()) {
            completeArgs.add("--properties-file");
            completeArgs.add(FileUtil.getAbsolutePath((File)propertiesFile));
        }
        if (Validator.isNotNull((String)(url = this.getUrl()))) {
            completeArgs.add("--url");
            completeArgs.add(url);
        }
        if (Validator.isNotNull((String)(userName = this.getUserName()))) {
            completeArgs.add("--user-name");
            completeArgs.add(userName);
        }
        completeArgs.add(this.getCommand());
        return completeArgs;
    }
}

