/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.baseline.internal.util;

import com.liferay.gradle.util.FileUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskContainer;

public class GradleUtil
extends com.liferay.gradle.util.GradleUtil {
    public static <T extends Task> T addTask(Project project, String name, Class<T> clazz, boolean overwrite) {
        block3: {
            if (overwrite) {
                try {
                    Task task = GradleUtil.getTask((Project)project, (String)name);
                    GradleUtil.removeTask(project, task);
                }
                catch (Exception exception) {
                    Logger logger = project.getLogger();
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Unable to remove task {}:{}", (Object)project.getPath(), (Object)name);
                }
            }
        }
        return (T)GradleUtil.addTask((Project)project, (String)name, clazz);
    }

    public static File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    public static boolean isFromMavenLocal(Project project, File file) {
        RepositoryHandler repositoryHandler = project.getRepositories();
        ArtifactRepository artifactRepository = (ArtifactRepository)repositoryHandler.findByName("MavenLocal");
        if (!(artifactRepository instanceof MavenArtifactRepository)) {
            return false;
        }
        MavenArtifactRepository mavenArtifactRepository = (MavenArtifactRepository)artifactRepository;
        Path repositoryPath = Paths.get(mavenArtifactRepository.getUrl());
        return FileUtil.isChild((File)file, (File)repositoryPath.toFile());
    }

    public static void removeTask(Project project, Task task) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.remove((Object)task);
    }

    public static boolean toBoolean(Object object) {
        if ((object = GradleUtil.toObject((Object)object)) instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        return false;
    }
}

