/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.app.docker;

import com.bmuschko.gradle.docker.DockerRemoteApiPlugin;
import com.bmuschko.gradle.docker.tasks.image.DockerBuildImage;
import com.bmuschko.gradle.docker.tasks.image.DockerPushImage;
import com.bmuschko.gradle.docker.tasks.image.DockerTagImage;
import com.liferay.gradle.plugins.app.docker.AppDockerExtension;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.tools.ant.filters.FixCrLfFilter;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.War;

public class AppDockerPlugin
implements Plugin<Project> {
    public static final String BUILD_APP_DOCKER_IMAGE_TASK_NAME = "buildAppDockerImage";
    public static final String PLUGIN_NAME = "appDocker";
    public static final String PREPARE_APP_DOCKER_IMAGE_INPUT_DIR_TASK_NAME = "prepareAppDockerImageInputDir";
    public static final String PUSH_APP_DOCKER_IMAGE_TASK_NAME = "pushAppDockerImage";
    public static final String TAG_APP_DOCKER_IMAGE_TASK_NAME = "tagAppDockerImage";
    private static final Map<String, Object> _fixCrLfArgs = new HashMap<String, Object>();

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, DockerRemoteApiPlugin.class);
        final AppDockerExtension appDockerExtension = (AppDockerExtension)GradleUtil.addExtension((ExtensionAware)project, (String)PLUGIN_NAME, AppDockerExtension.class);
        final Sync prepareAppDockerImageInputDirTask = this._addTaskPrepareAppDockerImageInputDir(project, appDockerExtension);
        final DockerBuildImage buildAppDockerImageTask = this._addTaskBuildAppDockerImage(prepareAppDockerImageInputDirTask, appDockerExtension);
        final DockerPushImage pushAppDockerImageTask = this._addTaskPushAppDockerImage(buildAppDockerImageTask, appDockerExtension);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                AppDockerPlugin.this._addTasksPushAppDockerImage(buildAppDockerImageTask, pushAppDockerImageTask, appDockerExtension);
            }
        });
        Gradle gradle = project.getGradle();
        gradle.afterProject((Closure)new Closure<Void>((Object)project){

            public void doCall(Project subproject) {
                AppDockerPlugin.this._configureTaskPrepareAppDockerImageInputDir(prepareAppDockerImageInputDirTask, appDockerExtension, subproject);
            }
        });
    }

    private DockerBuildImage _addTaskBuildAppDockerImage(final Sync prepareAppDockerImageInputDirTask, final AppDockerExtension appDockerExtension) {
        Project project = prepareAppDockerImageInputDirTask.getProject();
        DockerBuildImage dockerBuildImage = (DockerBuildImage)GradleUtil.addTask((Project)project, (String)BUILD_APP_DOCKER_IMAGE_TASK_NAME, DockerBuildImage.class);
        dockerBuildImage.setDependsOn(Collections.singleton(prepareAppDockerImageInputDirTask));
        dockerBuildImage.setDescription("Builds the Docker image of the app.");
        dockerBuildImage.setGroup("build");
        DslObject dslObject = new DslObject((Object)dockerBuildImage);
        ConventionMapping conventionMapping = dslObject.getConventionMapping();
        conventionMapping.map("inputDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return prepareAppDockerImageInputDirTask.getDestinationDir();
            }
        });
        conventionMapping.map("tag", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AppDockerPlugin.this._getImageRepository(appDockerExtension);
            }
        });
        return dockerBuildImage;
    }

    private Sync _addTaskPrepareAppDockerImageInputDir(final Project project, final AppDockerExtension appDockerExtension) {
        Sync sync = (Sync)GradleUtil.addTask((Project)project, (String)PREPARE_APP_DOCKER_IMAGE_INPUT_DIR_TASK_NAME, Sync.class);
        sync.filesMatching("**/*.sh", (Action)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(_fixCrLfArgs, FixCrLfFilter.class);
            }
        });
        sync.from(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return appDockerExtension.getInputDir();
            }
        }});
        sync.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), "docker");
            }
        });
        sync.setDescription("Copies all the subproject artifacts and other resources to a temporary directory that will be used to build the Docker image of the app.");
        return sync;
    }

    private DockerPushImage _addTaskPushAppDockerImage(DockerBuildImage buildAppDockerImageTask, final AppDockerExtension appDockerExtension) {
        DockerPushImage dockerPushImage = (DockerPushImage)GradleUtil.addTask((Project)buildAppDockerImageTask.getProject(), (String)PUSH_APP_DOCKER_IMAGE_TASK_NAME, DockerPushImage.class);
        dockerPushImage.setDependsOn(Collections.singleton(buildAppDockerImageTask));
        dockerPushImage.setDescription("Pushes the Docker image of the app to the registry.");
        dockerPushImage.setGroup("upload");
        DslObject dslObject = new DslObject((Object)dockerPushImage);
        ConventionMapping conventionMapping = dslObject.getConventionMapping();
        conventionMapping.map("imageName", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AppDockerPlugin.this._getImageRepository(appDockerExtension);
            }
        });
        return dockerPushImage;
    }

    private DockerPushImage _addTaskPushAppDockerImage(DockerTagImage dockerTagImage) {
        String imageRepositoryAndTag = this._getImageRepositoryAndTag(dockerTagImage.getRepository(), dockerTagImage.getTag());
        DockerPushImage dockerPushImage = (DockerPushImage)GradleUtil.addTask((Project)dockerTagImage.getProject(), (String)("pushAppDockerImage_" + imageRepositoryAndTag), DockerPushImage.class);
        dockerPushImage.setDependsOn(Collections.singleton(dockerTagImage));
        dockerPushImage.setDescription("Pushes the Docker image \"" + imageRepositoryAndTag + "\" to the registry.");
        dockerPushImage.setImageName(dockerTagImage.getRepository());
        dockerPushImage.setTag(dockerTagImage.getTag());
        return dockerPushImage;
    }

    private void _addTasksPushAppDockerImage(DockerBuildImage buildAppDockerImageTask, DockerPushImage pushAppDockerImageTask, AppDockerExtension appDockerExtension) {
        String imageRepository = this._getImageRepository(appDockerExtension);
        for (Object imageTagObject : appDockerExtension.getImageTags()) {
            String imageTag = GradleUtil.toString((Object)imageTagObject);
            if (Validator.isNull((String)imageTag)) continue;
            DockerTagImage dockerTagImage = this._addTaskTagAppDockerImage(buildAppDockerImageTask, imageRepository, imageTag);
            DockerPushImage dockerPushImage = this._addTaskPushAppDockerImage(dockerTagImage);
            pushAppDockerImageTask.dependsOn(new Object[]{dockerPushImage});
        }
    }

    private DockerTagImage _addTaskTagAppDockerImage(final DockerBuildImage buildAppDockerImagetask, String imageRepository, String imageTag) {
        Project project = buildAppDockerImagetask.getProject();
        String imageRepositoryAndTag = this._getImageRepositoryAndTag(imageRepository, imageTag);
        DockerTagImage dockerTagImage = (DockerTagImage)GradleUtil.addTask((Project)project, (String)("tagAppDockerImage_" + imageRepositoryAndTag), DockerTagImage.class);
        dockerTagImage.setDependsOn(Collections.singleton(buildAppDockerImagetask));
        dockerTagImage.setDescription("Creates the tag \"" + imageRepositoryAndTag + "\" which refers to the Docker image of the app.");
        dockerTagImage.setRepository(imageRepository);
        dockerTagImage.setTag(imageTag);
        dockerTagImage.targetImageId((Closure)new Closure<String>((Object)project){

            public String doCall() {
                return buildAppDockerImagetask.getImageId();
            }
        });
        return dockerTagImage;
    }

    private void _configureTaskPrepareAppDockerImageInputDir(Sync prepareAppDockerImageInputDirTask, AppDockerExtension appDockerExtension, Project subproject) {
        Logger logger = prepareAppDockerImageInputDirTask.getLogger();
        Set<Project> subprojects = appDockerExtension.getSubprojects();
        if (!subprojects.contains(subproject)) {
            if (logger.isInfoEnabled()) {
                logger.info("Excluding {} from {}", (Object)subproject, (Object)prepareAppDockerImageInputDirTask);
            }
            return;
        }
        Spec<Project> spec = appDockerExtension.getOnlyIf();
        if (!spec.isSatisfiedBy((Object)subproject)) {
            if (logger.isInfoEnabled()) {
                logger.info("Explicitly excluding {} from {}", (Object)subproject, (Object)prepareAppDockerImageInputDirTask);
            }
            return;
        }
        PluginContainer pluginContainer = subproject.getPlugins();
        if (pluginContainer.hasPlugin(WarPlugin.class)) {
            War war = (War)GradleUtil.getTask((Project)subproject, (String)"war");
            prepareAppDockerImageInputDirTask.from(new Object[]{war});
        } else {
            Configuration configuration = GradleUtil.getConfiguration((Project)subproject, (String)"default");
            PublishArtifactSet publishArtifactSet = configuration.getAllArtifacts();
            prepareAppDockerImageInputDirTask.from(new Object[]{publishArtifactSet.getFiles()});
        }
    }

    private String _getImageRepository(AppDockerExtension appDockerExtension) {
        String imageUser = appDockerExtension.getImageUser();
        String imageName = appDockerExtension.getImageName();
        if (Validator.isNull((String)imageUser)) {
            return imageName;
        }
        return imageUser + "/" + imageName;
    }

    private String _getImageRepositoryAndTag(String imageRepository, String imageTag) {
        if (Validator.isNull((String)imageTag)) {
            return imageRepository;
        }
        return imageRepository + ":" + imageTag;
    }

    static {
        _fixCrLfArgs.put("eof", FixCrLfFilter.AddAsisRemove.newInstance((String)"remove"));
        _fixCrLfArgs.put("eol", FixCrLfFilter.CrLf.newInstance((String)"lf"));
        _fixCrLfArgs.put("fixlast", false);
    }
}

