/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.token.definition.internal;

import com.liferay.frontend.token.definition.FrontendToken;
import com.liferay.frontend.token.definition.FrontendTokenMapping;
import com.liferay.frontend.token.definition.FrontendTokenSet;
import com.liferay.frontend.token.definition.internal.json.JSONLocalizer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

/**
 * @author Iván Zaera
 */
public class FrontendTokenSetImpl implements FrontendTokenSet {

	public FrontendTokenSetImpl(
		FrontendTokenCategoryImpl frontendTokenCategoryImpl,
		JSONObject jsonObject) {

		_frontendTokenCategoryImpl = frontendTokenCategoryImpl;

		FrontendTokenDefinitionImpl frontendTokenDefinitionImpl =
			frontendTokenCategoryImpl.getFrontendTokenDefinition();

		_jsonLocalizer = frontendTokenDefinitionImpl.createJSONLocalizer(
			jsonObject);

		JSONArray frontendTokensJSONArray = jsonObject.getJSONArray(
			"frontendTokens");

		if (frontendTokensJSONArray == null) {
			return;
		}

		for (int i = 0; i < frontendTokensJSONArray.length(); i++) {
			FrontendToken frontendToken = new FrontendTokenImpl(
				this, frontendTokensJSONArray.getJSONObject(i));

			_frontendTokens.add(frontendToken);

			_frontendTokenMappings.addAll(
				frontendToken.getFrontendTokenMappings());
		}
	}

	@Override
	public FrontendTokenCategoryImpl getFrontendTokenCategory() {
		return _frontendTokenCategoryImpl;
	}

	@Override
	public Collection<FrontendTokenMapping> getFrontendTokenMappings() {
		return _frontendTokenMappings;
	}

	@Override
	public Collection<FrontendToken> getFrontendTokens() {
		return _frontendTokens;
	}

	@Override
	public String getJSON(Locale locale) {
		return _jsonLocalizer.getJSON(locale);
	}

	protected FrontendTokenDefinitionImpl getFrontendTokenDefinition() {
		return _frontendTokenCategoryImpl.getFrontendTokenDefinition();
	}

	private final FrontendTokenCategoryImpl _frontendTokenCategoryImpl;
	private final Collection<FrontendTokenMapping> _frontendTokenMappings =
		new ArrayList<>();
	private final Collection<FrontendToken> _frontendTokens = new ArrayList<>();
	private final JSONLocalizer _jsonLocalizer;

}