/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.token.definition.internal;

import com.liferay.frontend.token.definition.FrontendToken;
import com.liferay.frontend.token.definition.FrontendTokenCategory;
import com.liferay.frontend.token.definition.FrontendTokenMapping;
import com.liferay.frontend.token.definition.FrontendTokenSet;
import com.liferay.frontend.token.definition.internal.json.JSONLocalizer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

/**
 * @author Iván Zaera
 */
public class FrontendTokenCategoryImpl implements FrontendTokenCategory {

	public FrontendTokenCategoryImpl(
		FrontendTokenDefinitionImpl frontendTokenDefinitionImpl,
		JSONObject jsonObject) {

		_frontendTokenDefinitionImpl = frontendTokenDefinitionImpl;

		_jsonLocalizer = frontendTokenDefinitionImpl.createJSONLocalizer(
			jsonObject);

		JSONArray frontendTokenSetsJSONArray = jsonObject.getJSONArray(
			"frontendTokenSets");

		if (frontendTokenSetsJSONArray == null) {
			return;
		}

		for (int i = 0; i < frontendTokenSetsJSONArray.length(); i++) {
			FrontendTokenSet frontendTokenSet = new FrontendTokenSetImpl(
				this, frontendTokenSetsJSONArray.getJSONObject(i));

			_frontendTokenMappings.addAll(
				frontendTokenSet.getFrontendTokenMappings());

			_frontendTokens.addAll(frontendTokenSet.getFrontendTokens());

			_frontendTokenSets.add(frontendTokenSet);
		}
	}

	@Override
	public FrontendTokenDefinitionImpl getFrontendTokenDefinition() {
		return _frontendTokenDefinitionImpl;
	}

	@Override
	public Collection<FrontendTokenMapping> getFrontendTokenMappings() {
		return _frontendTokenMappings;
	}

	@Override
	public Collection<FrontendToken> getFrontendTokens() {
		return _frontendTokens;
	}

	@Override
	public Collection<FrontendTokenSet> getFrontendTokenSets() {
		return _frontendTokenSets;
	}

	@Override
	public String getJSON(Locale locale) {
		return _jsonLocalizer.getJSON(locale);
	}

	private final FrontendTokenDefinitionImpl _frontendTokenDefinitionImpl;
	private final Collection<FrontendTokenMapping> _frontendTokenMappings =
		new ArrayList<>();
	private final Collection<FrontendToken> _frontendTokens = new ArrayList<>();
	private final Collection<FrontendTokenSet> _frontendTokenSets =
		new ArrayList<>();
	private final JSONLocalizer _jsonLocalizer;

}