/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal.frontend.css.variables;

import com.liferay.frontend.css.variables.ScopedCSSVariables;
import com.liferay.frontend.css.variables.ScopedCSSVariablesProvider;
import com.liferay.frontend.token.definition.FrontendToken;
import com.liferay.frontend.token.definition.FrontendTokenDefinition;
import com.liferay.frontend.token.definition.FrontendTokenDefinitionRegistry;
import com.liferay.frontend.token.definition.FrontendTokenMapping;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=2147483647"}, service={ScopedCSSVariablesProvider.class})
public class DefaultThemeScopedCSSVariablesProvider
implements ScopedCSSVariablesProvider {
    @Reference
    private FrontendTokenDefinitionRegistry _frontendTokenDefinitionRegistry;

    public Collection<ScopedCSSVariables> getScopedCSSVariablesCollection(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        FrontendTokenDefinition frontendTokenDefinition = null;
        String styleBookEntryThemeId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"styleBookEntryThemeId");
        frontendTokenDefinition = Validator.isNotNull((String)styleBookEntryThemeId) ? this._frontendTokenDefinitionRegistry.getFrontendTokenDefinition(themeDisplay.getCompanyId(), styleBookEntryThemeId) : this._frontendTokenDefinitionRegistry.getFrontendTokenDefinition(themeDisplay.getLayout());
        if (frontendTokenDefinition == null) {
            return Collections.emptyList();
        }
        final HashMap<String, String> cssVariables = new HashMap<String, String>();
        Collection frontendTokens = frontendTokenDefinition.getFrontendTokens();
        for (FrontendToken frontendToken : frontendTokens) {
            Collection frontendTokenMappings = frontendToken.getFrontendTokenMappings("cssVariable");
            for (FrontendTokenMapping frontendTokenMapping : frontendTokenMappings) {
                if (!Validator.isNotNull((String)String.valueOf(frontendToken.getDefaultValue()))) continue;
                cssVariables.put(frontendTokenMapping.getValue(), String.valueOf(frontendToken.getDefaultValue()));
            }
        }
        return Collections.singletonList(new ScopedCSSVariables(){

            public Map<String, String> getCSSVariables() {
                return cssVariables;
            }

            public String getScope() {
                return ":root";
            }
        });
    }
}

