/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal;

import com.liferay.frontend.token.definition.FrontendToken;
import com.liferay.frontend.token.definition.FrontendTokenMapping;
import com.liferay.frontend.token.definition.FrontendTokenSet;
import com.liferay.frontend.token.definition.internal.FrontendTokenCategoryImpl;
import com.liferay.frontend.token.definition.internal.FrontendTokenDefinitionImpl;
import com.liferay.frontend.token.definition.internal.FrontendTokenImpl;
import com.liferay.frontend.token.definition.internal.json.JSONLocalizer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class FrontendTokenSetImpl
implements FrontendTokenSet {
    private final FrontendTokenCategoryImpl _frontendTokenCategoryImpl;
    private final Collection<FrontendTokenMapping> _frontendTokenMappings = new ArrayList<FrontendTokenMapping>();
    private final Collection<FrontendToken> _frontendTokens = new ArrayList<FrontendToken>();
    private final JSONLocalizer _jsonLocalizer;

    public FrontendTokenSetImpl(FrontendTokenCategoryImpl frontendTokenCategoryImpl, JSONObject jsonObject) {
        this._frontendTokenCategoryImpl = frontendTokenCategoryImpl;
        FrontendTokenDefinitionImpl frontendTokenDefinitionImpl = frontendTokenCategoryImpl.getFrontendTokenDefinition();
        this._jsonLocalizer = frontendTokenDefinitionImpl.createJSONLocalizer(jsonObject);
        JSONArray frontendTokensJSONArray = jsonObject.getJSONArray("frontendTokens");
        if (frontendTokensJSONArray == null) {
            return;
        }
        for (int i = 0; i < frontendTokensJSONArray.length(); ++i) {
            FrontendTokenImpl frontendToken = new FrontendTokenImpl(this, frontendTokensJSONArray.getJSONObject(i));
            this._frontendTokens.add(frontendToken);
            this._frontendTokenMappings.addAll(frontendToken.getFrontendTokenMappings());
        }
    }

    public FrontendTokenCategoryImpl getFrontendTokenCategory() {
        return this._frontendTokenCategoryImpl;
    }

    public Collection<FrontendTokenMapping> getFrontendTokenMappings() {
        return this._frontendTokenMappings;
    }

    public Collection<FrontendToken> getFrontendTokens() {
        return this._frontendTokens;
    }

    public JSONObject getJSONObject(Locale locale) {
        return this._jsonLocalizer.getJSONObject(locale);
    }

    protected FrontendTokenDefinitionImpl getFrontendTokenDefinition() {
        return this._frontendTokenCategoryImpl.getFrontendTokenDefinition();
    }
}

