/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal;

import com.liferay.frontend.token.definition.FrontendToken;
import com.liferay.frontend.token.definition.FrontendTokenCategory;
import com.liferay.frontend.token.definition.FrontendTokenDefinition;
import com.liferay.frontend.token.definition.FrontendTokenMapping;
import com.liferay.frontend.token.definition.FrontendTokenSet;
import com.liferay.frontend.token.definition.internal.FrontendTokenCategoryImpl;
import com.liferay.frontend.token.definition.internal.json.JSONLocalizer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class FrontendTokenDefinitionImpl
implements FrontendTokenDefinition {
    private final Collection<FrontendTokenCategory> _frontendTokenCategories = new ArrayList<FrontendTokenCategory>();
    private final Collection<FrontendTokenMapping> _frontendTokenMappings = new ArrayList<FrontendTokenMapping>();
    private final Collection<FrontendToken> _frontendTokens = new ArrayList<FrontendToken>();
    private final Collection<FrontendTokenSet> _frontendTokenSets = new ArrayList<FrontendTokenSet>();
    private final JSONFactory _jsonFactory;
    private final JSONLocalizer _jsonLocalizer;
    private final ResourceBundleLoader _resourceBundleLoader;
    private final String _themeId;
    private final String _themeName;
    private final String _themeType;

    public FrontendTokenDefinitionImpl(JSONObject jsonObject, JSONFactory jsonFactory, ResourceBundleLoader resourceBundleLoader, String themeId, String themeName, String themeType) {
        this._jsonFactory = jsonFactory;
        this._resourceBundleLoader = resourceBundleLoader;
        this._themeId = themeId;
        this._themeName = themeName;
        this._themeType = themeType;
        this._jsonLocalizer = this.createJSONLocalizer(jsonObject);
        JSONArray frontendTokenCategoriesJSONArray = jsonObject.getJSONArray("frontendTokenCategories");
        if (frontendTokenCategoriesJSONArray == null) {
            return;
        }
        for (int i = 0; i < frontendTokenCategoriesJSONArray.length(); ++i) {
            FrontendTokenCategoryImpl frontendTokenCategory = new FrontendTokenCategoryImpl(this, frontendTokenCategoriesJSONArray.getJSONObject(i));
            this._frontendTokenCategories.add(frontendTokenCategory);
            this._frontendTokenMappings.addAll(frontendTokenCategory.getFrontendTokenMappings());
            this._frontendTokens.addAll(frontendTokenCategory.getFrontendTokens());
            this._frontendTokenSets.addAll(frontendTokenCategory.getFrontendTokenSets());
        }
    }

    public Collection<FrontendTokenCategory> getFrontendTokenCategories() {
        return this._frontendTokenCategories;
    }

    public Collection<FrontendTokenMapping> getFrontendTokenMappings() {
        return this._frontendTokenMappings;
    }

    public Collection<FrontendToken> getFrontendTokens() {
        return this._frontendTokens;
    }

    public Collection<FrontendTokenSet> getFrontendTokenSets() {
        return this._frontendTokenSets;
    }

    public JSONObject getJSONObject(Locale locale) {
        return this._jsonLocalizer.getJSONObject(locale);
    }

    public String getThemeId() {
        return this._themeId;
    }

    public String getThemeName(Locale locale) {
        return LocalizationUtil.getLocalization((String)this._themeName, (String)LocaleUtil.toLanguageId((Locale)locale));
    }

    public String getThemeType() {
        return this._themeType;
    }

    protected JSONLocalizer createJSONLocalizer(JSONObject jsonObject) {
        return new JSONLocalizer(this._jsonFactory.looseSerializeDeep((Object)jsonObject), this._jsonFactory, this._resourceBundleLoader, this._themeId);
    }
}

